package jp.agentec.abook.abv.bl.common.log;


public enum LogLevel {
	verbose(0),
	debug(1),
	info(2),
	warn(3),
	error(4);
	
	private final int levelNo;
	
	LogLevel(int levelNo) {
		this.levelNo = levelNo;
	}
	
	public int level() {
		return levelNo;
	}
	
	public static LogLevel level(int value) {
		
		LogLevel level;
		
		switch (value) {
		case 0:
			level = LogLevel.verbose;
			break;
		case 2:
			level = LogLevel.info;
			break;
		case 3:
			level = LogLevel.warn;
			break;
		case 4:
			level = LogLevel.error;
			break;
		default:
			level = LogLevel.debug;
			break;
		}
		
		return level;
	}
}
