package jp.agentec.abook.abv.bl.data.dao;

import java.util.Calendar;
import java.util.List;

import jp.agentec.abook.abv.bl.acms.type.ContentReadingStatus;
import jp.agentec.abook.abv.bl.common.Constant.ReadingLogMode;
import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.dto.ContentReadingLogDto;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;
import jp.agentec.adf.util.StringUtil;

public class ContentReadingLogDao extends AbstractDao {

	/**
	 * {@link MemberInfoDao} のインスタンスを初期化します。
	 * context アンドロイドの android.content.Context のインスタンス
	 * @throws ClassCastException 引数のcontextが android.content.Context 又は、その継承クラスではありません。
	 * @since 1.0.0
	 */
	/*package*/ ContentReadingLogDao() {
	}

	@Override
	protected ContentReadingLogDto convert(Cursor cursor) {
		ContentReadingLogDto dto = new ContentReadingLogDto();

		int colnum = cursor.getColumnIndex("content_id");
		if (colnum != -1) {
			dto.contentId = cursor.getLong(colnum);
		}
		colnum = cursor.getColumnIndex("reading_log_id");
		if (colnum != -1) {
			dto.readingLogId = cursor.getInt(colnum);
		}
		colnum = cursor.getColumnIndex("status");
		if (colnum != -1) {
			dto.status = cursor.getInt(colnum);
		}
		colnum = cursor.getColumnIndex("start_date");
		if (colnum != -1) {
			dto.startDate = DateTimeUtil.toDate(cursor.getString(colnum), "UTC", DateTimeFormat.yyyyMMddHHmmss_hyphen);
		}
		colnum = cursor.getColumnIndex("resume_date");
		if (colnum != -1) {
			dto.resumeDate = DateTimeUtil.toDate(cursor.getString(colnum), "UTC", DateTimeFormat.yyyyMMddHHmmss_hyphen);
		}
		colnum = cursor.getColumnIndex("end_date");
		if (colnum != -1) {
			dto.endDate = DateTimeUtil.toDate(cursor.getString(colnum), "UTC", DateTimeFormat.yyyyMMddHHmmss_hyphen);
		}
		colnum = cursor.getColumnIndex("duration");
		if (colnum != -1) {
			dto.duration = cursor.getInt(colnum);
		}
		colnum = cursor.getColumnIndex("latitude");
		if (colnum != -1) {
			if(StringUtil.isNullOrEmpty(cursor.getString(colnum))){
				dto.latitude = null;
			} else {
				dto.latitude = cursor.getDouble(colnum);
			}
		}
		colnum = cursor.getColumnIndex("longitude");
		if (colnum != -1) {
			if(StringUtil.isNullOrEmpty(cursor.getString(colnum))){
				dto.longitude = null;
			} else {
				dto.longitude = cursor.getDouble(colnum);
			}
		}
		colnum = cursor.getColumnIndex("mode");
		if (colnum != -1) {
			dto.mode = cursor.getInt(colnum);
		}

		return dto;
	}

	public int getNewContentReadingLogId() {
		StringBuffer sql = new StringBuffer();
		sql.append(" SELECT " );
		sql.append( " COALESCE(MAX(reading_log_id)+1,1)");
		sql.append( " FROM l_content_reading_log");
		return rawQueryGetInt(sql.toString(), null);
	}

	public ContentReadingLogDto getContentReadingLog(long contentId) {
		String[] args = new String[]{""+ contentId, ""+ ContentReadingStatus.reading.type(), ""+ ContentReadingStatus.suspend.type(), "" + ReadingLogMode.DEFAULT};
		return rawQueryGetDto("select * from l_content_reading_log where content_id=? and status IN(?,?) and mode=?", args, ContentReadingLogDto.class);
	}

	public List<ContentReadingLogDto> getContentReadLogs() { // TODO: 下のメソッドを呼び出すべき
		String[] args = new String[] { ""+ ContentReadingStatus.readed.type()};
		return rawQueryGetDtoList("select * from l_content_reading_log where status=?", args, ContentReadingLogDto.class);
	}

	public List<ContentReadingLogDto> getContentReadLogs(ContentReadingStatus status) {
		String[] args = new String[] { "" +  status.type()};
		return rawQueryGetDtoList("select * from l_content_reading_log where status=?", args, ContentReadingLogDto.class);
	}

	public void insertContentReadingLog(ContentReadingLogDto dto) {
		insert("insert into l_content_reading_log (reading_log_id, content_id, status, start_date, resume_Date, end_date, duration, latitude, longitude, mode) values (?,?,?,?,?,?,?,?,?,?)", dto.getInsertValues());
	}

	public boolean updateContentReadingLog(ContentReadingLogDto dto) {
		long count = update("update l_content_reading_log set content_id=?, status=?, start_date=?, resume_Date=?, end_date=?, duration=?, latitude=?, longitude=?, mode=? where reading_log_id = ?", dto.getUpdateValues());
		return count > 0;
	}

	public boolean deleteContentReadingLog(ContentReadingLogDto dto) {
		long ret = delete("l_content_reading_log", "reading_log_id=?", dto.getKeyValues());
		return ret > 0;
	}
	
	public List<ContentReadingLogDto> getUnendSignageLog() {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		String today0hour = DateTimeUtil.toStringInTimeZone(cal.getTime(), DateTimeFormat.yyyyMMddHHmmssSSS_hyphen, "UTC");
		String[] args = new String[]{""+ ContentReadingStatus.reading.type(), ""+ ContentReadingStatus.suspend.type(), today0hour, today0hour};
		return rawQueryGetDtoList("select * from l_content_reading_log where mode=2 and status IN(?,?) and start_date < ? and end_date < ?", args, ContentReadingLogDto.class);
	}

	/**
	 * 指定コンテンツID（カンマ区切り複数指定）のログを削除する
	 * 
	 * @param deletedList
	 */
	public void deleteUnsendLog(String deletedList) {
		if (deletedList == null || deletedList.isEmpty()) {
			return;
		}
		update("delete from l_content_reading_log where content_id in ("+ deletedList +")", null);
	}
}