package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.dto.AbstractDto;
import jp.agentec.abook.abv.bl.dto.ContentResourceDto;

public class ContentResourceDao extends AbstractDao {

	/*package*/ ContentResourceDao() {
	}

	@Override
	protected ContentResourceDto convert(Cursor cursor) {
		ContentResourceDto dto = new ContentResourceDto();

		int colnum = cursor.getColumnIndex("content_id");
		if (colnum != -1) {
			dto.contentId = cursor.getInt(colnum);
		}
		colnum = cursor.getColumnIndex("sub_directory");
		if (colnum != -1) {
			dto.subDirectory = cursor.getString(colnum);
		}
		colnum = cursor.getColumnIndex("resource_file_name");
		if (colnum != -1) {
			dto.resourceFileName = cursor.getString(colnum);
		}
		colnum = cursor.getColumnIndex("hashed_file_name");
		if (colnum != -1) {
			dto.hashedFileName = cursor.getString(colnum);
		}
		colnum = cursor.getColumnIndex("hashed_file_header");
		if (colnum != -1) {
			dto.hashedFileHeader = cursor.getBlob(colnum);
		}

		return dto;
	}

	public List<ContentResourceDto> getContentResources(long contentId) {
		return rawQueryGetDtoList("select * from t_content_resource where content_id=?", new String[]{""+ contentId}, ContentResourceDto.class);
	}

	public void insertContentResource(long contentId, List<AbstractDto> list) {
		for (AbstractDto dto : list) {
			insert("insert into t_content_resource (content_id, sub_directory, resource_file_name, hashed_file_name, hashed_file_header) values (?,?,?,?,?)", dto.getInsertValues());
		}
		update("update t_content set content_protected_flg=1 where content_id=?", new Object[]{contentId});
	}

	public void deleteContentResources(long contentId) {
		delete("t_content_resource", "content_id=?", new String[]{""+ contentId});
	}
}
