package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.common.db.SQLiteStatement;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.OperationGroupMasterRelationDto;

/**
 * Created by leej on 2019/06/26.
 */

public class OperationGroupMasterOperationDao extends AbstractDao {
    private static final String TAG = "OperationGroupMasterDao";

    private enum QueryType {GetAllGroups, GetRootGroups, GetGroups}

    /*package*/ OperationGroupMasterOperationDao() {
    }

    @Override
    protected OperationGroupMasterRelationDto convert(Cursor cursor) {
        OperationGroupMasterRelationDto dto = new OperationGroupMasterRelationDto();

        int column = cursor.getColumnIndex("operation_group_master_id");
        if (column != -1) {
            dto.operationGroupMasterId = cursor.getInt(column);
        }
        column = cursor.getColumnIndex("operation_id");
        if (column != -1) {
            dto.operationId = cursor.getLong(column);
        }
        return dto;
    }

    /**
     * 作業種別と作業のリレーションテーブル削除
     * @param operationGroupMasterId
     */
    public void deleteOperationGroupMasterOperation(Integer operationGroupMasterId, Long operationId) {
        delete("r_operation_group_master_relation", "operation_group_master_id=? AND operation_id=?", new String[]{""+ operationGroupMasterId, ""+ operationId});
    }

    /**
     * 作業種別と作業のリレーションテーブルのDB登録処理
     * @param dto
     */
    public boolean insertOperationGroupMasterOperation(OperationGroupMasterRelationDto dto) {

        StringBuffer sql = new StringBuffer();

        sql.append(" INSERT OR IGNORE INTO r_operation_group_master_relation ");
        sql.append(" SELECT " + dto.operationGroupMasterId);
        sql.append("      , " + dto.operationId);
        sql.append("   FROM t_operation AS top ");
        sql.append("   LEFT OUTER JOIN r_operation_group_master_relation AS rmogm ");
        sql.append("     ON rmogm.operation_group_master_id = ? ");
        sql.append("    AND top.operation_id <> rmogm.operation_id ");
        sql.append("  WHERE top.operation_id = ? ");
        sql.append("  GROUP BY rmogm.operation_group_master_id ");

        SQLiteStatement stmt = null;

        Logger.v(TAG, "sql=%s", sql);
        try {
            SQLiteDatabase db = getDatabase();
            stmt = db.compileStatement(sql.toString());
            stmt.bindLong(1, dto.operationGroupMasterId);
            stmt.bindLong(2, dto.operationId);

            return (stmt.executeInsert() > 0);
        } finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /**
     * 作業種別IDで関連する作業のIDを取得
     * @param operationId
     * @return
     */
    public List<Integer> getOperationGroupMasterIds(Long operationId) {
        return rawQueryGetIntegerList("select operation_group_master_id from r_operation_group_master_relation where operation_id=?", new String[]{""+ operationId});
    }

    public List<OperationGroupMasterRelationDto> getAllGroupMasterRelation() {
        return rawQueryGetDtoList("select * from r_operation_group_master_relation", null, OperationGroupMasterRelationDto.class);
    }
}