package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.dto.ServiceOptionDto;

public class ServiceOptionDao extends AbstractDao {
	
	/**
	 * {@link ServiceOptionDao} のインスタンスを初期化します。
	 * アンドロイドの android.content.Context のインスタンス
	 * @throws ClassCastException 引数のcontextが android.content.Context 又は、その継承クラスではありません。
	 * @since 1.0.0
	 */
	/*package*/ ServiceOptionDao() {
	}
	
	@Override
	protected ServiceOptionDto convert(Cursor cursor) {
		ServiceOptionDto dto = new ServiceOptionDto();
		
		int column = cursor.getColumnIndex("service_option_id");
		if (column != -1) {
			dto.serviceOptionId = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("service_option_name");
		if (column != -1) {
			dto.serviceOptionName = cursor.getString(column);
		}
		column = cursor.getColumnIndex("service_option_disp_name");
		if (column != -1) {
			dto.serviceOptionDispName = cursor.getString(column);
		}
		column = cursor.getColumnIndex("val");
		if (column != -1) {
			dto.val = cursor.getString(column);
		}
		
		return dto;
	}

	public List<ServiceOptionDto> getServiceOptions() {
		return rawQueryGetDtoList("select * from m_service_option", null, ServiceOptionDto.class);
	}
	
	public ServiceOptionDto getServiceOptionFromId(int serviceOptionId) { 
		String[] args = new String[] {""+ serviceOptionId};
		return rawQueryGetDto("select * from m_service_option where service_option_id=?", args, ServiceOptionDto.class);
	}

	public void insertServiceOptions(List<ServiceOptionDto> list) {
		insert("insert into m_service_option (service_option_id,service_option_name,service_option_disp_name,val) values (?,?,?,?)", list);
	}
	
	public void deleteServiceOptions() {
		delete("m_service_option", null, null);
	}
}
