package jp.agentec.abook.abv.bl.dto;


import java.util.List;

/**
 * グループ情報を格納します。m_groupのPKであるgroup_relation_idはこのdtoの扱いません。内部的なキーはgetKyeValuesメソッドで定義してあります。
 * @author Taejin Hong
 * @version　1.1.0
 */
public class ChatGroupDto extends AbstractDto {
	public int groupId;
	public int parentGroupId = 0;
	public String groupName;
	public int contentCount = 0;
	public String displayCount;
	public String groupPath;
	public String favoriteRegisterDate = "";
	public int delFlg;
	public List<ShopMemberDto> groupMembers;
	public List<String> groupPathList;
	public String updateDate;

	public ChatGroupDto() {
	}

	public ChatGroupDto(int groupId, String groupName, int parentGroupId) {
		this.groupId = groupId;
		this.groupName = groupName;
		this.parentGroupId = parentGroupId;
	}

	@Override
	public Object[] getInsertValues() {
		return new Object[]{ groupId, parentGroupId, groupName };
	}

	@Override
	public String[] getKeyValues() {
		return new String[]{"" + groupId};
	}

	public String getGroupName() {
		return groupName;
	}
}
