package jp.agentec.abook.abv.bl.logic;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.agentec.abook.abv.bl.dto.ContentDto;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

/**
 * Created by ThanhChung on 2016/06/14.
 */
public class UnAuthorizedContentLogic {

    public List<ContentDto> hashContentList(List<ContentDto> listDto) {
        List<ContentDto> hashListDto = new ArrayList<ContentDto>();
        for (ContentDto dto: listDto) {
            if (!dto.isUnAuthorizedContent) {
                hashListDto.add(dto);
            }
        }
        return hashListDto;
    }

    public boolean isDeleteUnAuthorizedContent(Date downloadTime) {
        if (downloadTime == null) {
            return true;
        }
        String timeNow = DateTimeUtil.toString(DateTimeUtil.getCurrentDate(), DateTimeFormat.yyyyMMdd_hyphen);
        String downloadedTime = DateTimeUtil.toString(downloadTime, DateTimeFormat.yyyyMMdd_hyphen);
        return timeNow.compareTo(downloadedTime) == 1;
    }
}
