package jp.agentec.abook.abv.ui.common.util;

import android.content.ClipData;
import android.content.ClipDescription;
import android.content.ClipboardManager;
import android.content.Context;

public class ClipboardUtil {

	public static final void setText(Context context, String text) {
		// クリップボードに格納するItemを作成
		ClipData.Item item = new ClipData.Item(text);
		
		// MIMEtypeの作成
		String[] mimeType = {ClipDescription.MIMETYPE_TEXT_URILIST};
		
		ClipData clipData = new ClipData(new ClipDescription("text_data", mimeType), item);
		
		ClipboardManager clipboardManager = (ClipboardManager) context.getSystemService(Context.CLIPBOARD_SERVICE);
		clipboardManager.setPrimaryClip(clipData);
	}

}
