package jp.agentec.abook.abv.ui.viewer.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;

import java.util.List;

import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.viewer.activity.DeviceImageListActivity;
import jp.agentec.abook.abv.ui.viewer.view.CustomImage;

public class ImageGalleryAdapter extends BaseAdapter {
    Context context;
    LayoutInflater inflater;
    List<CustomImage> imageUriList;
    int mRowHeight;
    boolean isBaseSceneUpload;
    public ImageGalleryAdapter(Context context, List<CustomImage> imageUriList, int rowHeight, boolean isBaseSceneUpload) {
        this.context = context;
        this.imageUriList = imageUriList;
        this.mRowHeight = rowHeight;
        this.isBaseSceneUpload = isBaseSceneUpload;
        inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    }

    @Override
    public int getCount() {
        return imageUriList.size();
    }

    @Override
    public CustomImage getItem(int position) {
        return imageUriList.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            convertView = inflater.inflate(R.layout.item_device_thumbnail, null);
            holder = new ViewHolder();
            holder.mThumbnail = (ImageView) convertView.findViewById(R.id.iv_thumbnail);
            holder.mThumbnailSelected = (ImageView) convertView.findViewById(R.id.iv_thumbnail_selected);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }
        holder.mThumbnail.getLayoutParams().height = mRowHeight;
        holder.mThumbnail.requestLayout();

        CustomImage customImage = getItem(position);
        boolean isSelected = ((DeviceImageListActivity)context).containsCustomImageUri(customImage.mUri);

        holder.mThumbnailSelected.setImageResource(R.drawable.check_mark);
        holder.mThumbnailSelected.setVisibility(View.INVISIBLE);

        //ベースシーンチェック画像設定
        if (isBaseSceneUpload) {
            boolean isFirstImage = ((DeviceImageListActivity)context).firstCustomImageUri(customImage.mUri);
            if (isFirstImage) {
                holder.mThumbnailSelected.setImageResource(R.drawable.icon_base_content_check);
            }
        }

        if (isSelected) {
            holder.mThumbnailSelected.setVisibility(View.VISIBLE);
        }

        if (holder.customImage == null || !holder.customImage.mUri.equals(customImage.mUri)) {
            ((DeviceImageListActivity)context).mImageFetcher.loadImage(customImage.mUri, holder.mThumbnail, customImage.mOrientation);
            holder.customImage = customImage;
        }
        return convertView;
    }

    class ViewHolder {
        ImageView mThumbnail;
        ImageView mThumbnailSelected;
        CustomImage customImage;

    }
}
