/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.android.sdaiflib;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import com.nttdocomo.android.sdaiflib.BeaconName;
import java.util.ArrayList;
import java.util.List;

public class BeaconNameManager {
    private static final String ACTION_ADD_BEACON_NAME_SDA_SUFFIX = ".sda.action.ADD_BEACON_NAME";
    private static final String ACTION_REMOVE_BEACON_NAME_SDA_SUFFIX = ".sda.action.REMOVE_BEACON_NAME";
    private static final String ACTION_CLEAR_BEACON_NAME_SDA_SUFFIX = ".sda.action.CLEAR_BEACON_NAME";
    private static final String BEACON_NAME_URI = "content://com.nttdocomo.android.smartdeviceagent/beacon_name";
    private final Context mContext;
    private List<BeaconName> mBeaconNameData;

    public BeaconNameManager(Context context) {
        this.mContext = context;
    }

    public void add(int vendorId, int extraId, String name) {
        if (this.mContext == null || name == null || name.equals("")) {
            return;
        }
        Intent intent = new Intent();
        intent.setClassName("com.nttdocomo.android.smartdeviceagent", "com.nttdocomo.android.smartdeviceagent.beacon.BeaconService");
        intent.setAction(this.mContext.getPackageName() + ACTION_ADD_BEACON_NAME_SDA_SUFFIX);
        intent.putExtra(this.makeExtraName("VENDOR_ID"), vendorId);
        intent.putExtra(this.makeExtraName("EXTRA_ID"), extraId);
        intent.putExtra(this.makeExtraName("NAME"), name);
        this.mContext.startService(intent);
    }

    public void remove(int vendorId, int extraId) {
        if (this.mContext == null) {
            return;
        }
        Intent intent = new Intent();
        intent.setClassName("com.nttdocomo.android.smartdeviceagent", "com.nttdocomo.android.smartdeviceagent.beacon.BeaconService");
        intent.setAction(this.mContext.getPackageName() + ACTION_REMOVE_BEACON_NAME_SDA_SUFFIX);
        intent.putExtra(this.makeExtraName("VENDOR_ID"), vendorId);
        intent.putExtra(this.makeExtraName("EXTRA_ID"), extraId);
        this.mContext.startService(intent);
    }

    public void clear() {
        if (this.mContext == null) {
            return;
        }
        Intent intent = new Intent();
        intent.setClassName("com.nttdocomo.android.smartdeviceagent", "com.nttdocomo.android.smartdeviceagent.beacon.BeaconService");
        intent.setAction(this.mContext.getPackageName() + ACTION_CLEAR_BEACON_NAME_SDA_SUFFIX);
        this.mContext.startService(intent);
    }

    public List<BeaconName> get() {
        ContentResolver resolver = this.mContext.getContentResolver();
        Cursor cursor = resolver.query(Uri.parse((String)BEACON_NAME_URI), null, null, null, null);
        this.mBeaconNameData = new ArrayList<BeaconName>();
        if (cursor != null) {
            while (cursor.moveToNext()) {
                BeaconName entity = new BeaconName();
                int colId = cursor.getColumnIndex("name");
                if (!cursor.isNull(colId)) {
                    entity.setName(cursor.getString(colId));
                }
                if (!cursor.isNull(colId = cursor.getColumnIndex("vendorId"))) {
                    entity.setVendorId(cursor.getInt(colId));
                }
                if (!cursor.isNull(colId = cursor.getColumnIndex("extraId"))) {
                    entity.setExtraId(cursor.getInt(colId));
                }
                this.mBeaconNameData.add(entity);
            }
            cursor.close();
        }
        return this.mBeaconNameData;
    }

    private String makeExtraName(String name) {
        return this.mContext.getPackageName() + ".sda.extra." + name;
    }
}

