/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.android.sdaiflib;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import com.nttdocomo.android.sdaiflib.DeviceInfo;
import java.util.ArrayList;
import java.util.List;

public class GetDeviceInformation {
    private static final String DEVICE_INFO_URI = "content://com.nttdocomo.android.smartdeviceagent/devices";
    private static final String Tag = "SDALib_GetDeviceInformation";
    private Context mContext;
    private List<DeviceInfo> mDeviceInfo;

    public GetDeviceInformation() {
        this.mContext = null;
    }

    public GetDeviceInformation(Context context) {
        this.mContext = context;
    }

    public List<DeviceInfo> getInformation() {
        ContentResolver resolver = this.mContext.getContentResolver();
        Cursor cursor = resolver.query(Uri.parse((String)DEVICE_INFO_URI), null, null, null, null);
        this.mDeviceInfo = new ArrayList<DeviceInfo>();
        Log.d((String)Tag, (String)"Information get!");
        if (cursor != null) {
            while (cursor.moveToNext()) {
                DeviceInfo entity = new DeviceInfo();
                int colId = cursor.getColumnIndex("name");
                if (!cursor.isNull(colId)) {
                    entity.setName(cursor.getString(colId));
                }
                if (!cursor.isNull(colId = cursor.getColumnIndex("device_id"))) {
                    entity.setModelId(cursor.getInt(colId));
                }
                if (!cursor.isNull(colId = cursor.getColumnIndex("device_uid"))) {
                    entity.setUniqueId(cursor.getInt(colId));
                }
                if (!cursor.isNull(colId = cursor.getColumnIndex("bd_address"))) {
                    entity.setBdaddress(cursor.getString(colId));
                }
                if (!cursor.isNull(colId = cursor.getColumnIndex("state"))) {
                    entity.setState(cursor.getInt(colId));
                }
                if (!cursor.isNull(colId = cursor.getColumnIndex("capability"))) {
                    entity.setFeature(cursor.getInt(colId));
                }
                if (!cursor.isNull(colId = cursor.getColumnIndex("ex_sensor_type"))) {
                    entity.setExSensorType(cursor.getInt(colId));
                }
                if (!cursor.isNull(colId = cursor.getColumnIndex("illumination"))) {
                    entity.setIllumination(cursor.getBlob(colId));
                    entity.setIlluminationInfo(cursor);
                }
                if (!cursor.isNull(colId = cursor.getColumnIndex("vibration"))) {
                    entity.setVibration(cursor.getBlob(colId));
                    entity.setVibrationInfo(cursor);
                }
                if (!cursor.isNull(colId = cursor.getColumnIndex("beep"))) {
                    entity.setBeep(cursor.getBlob(colId));
                    entity.setBeepInfo(cursor);
                }
                if (!cursor.isNull(colId = cursor.getColumnIndex("duration"))) {
                    entity.setDuration(cursor.getBlob(colId));
                    entity.setDurationInfo(cursor);
                }
                this.mDeviceInfo.add(entity);
            }
            cursor.close();
        }
        return this.mDeviceInfo;
    }
}

