/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.android.sdaiflib;

import android.database.Cursor;
import com.nttdocomo.android.sdaiflib.DetailSetting;
import com.nttdocomo.android.sdaiflib.ItemName;
import java.util.ArrayList;
import java.util.List;

public class InformationData {
    private static final String LANG_JA = "ja";
    private static final String LANG_EN = "en";
    private static final int TYPE_ILL_PATTERN = 0;
    private static final int TYPE_ILL_COLOR = 1;
    private static final int TYPE_BEP = 2;
    private static final int TYPE_VIB = 3;
    private static final int TYPE_DUR = 4;
    private static final String[][] mColName = new String[][]{{"ill_pattern_id", "ill_pattern_defid", "ill_pattern_name_ja", "ill_pattern_name_en", "ill_pattern_num", "ill_pattern_detail_selected_id_", "ill_pattern_detail_selected_item_"}, {"ill_color_id", "ill_color_defid", "ill_color_name_ja", "ill_color_name_en", "ill_color_num", "ill_color_detail_selected_id_", "ill_color_detail_selected_item_"}, {"bep_id", "bep_defid", "bep_name_ja", "bep_name_en", "bep_num", "bep_detail_selected_id_", "bep_detail_selected_item_"}, {"vib_id", "vib_defid", "vib_name_ja", "vib_name_en", "vib_num", "vib_detail_selected_id_", "vib_detail_selected_item_"}, {"dur_id", "dur_defid", "dur_name_ja", "dur_name_en", "dur_num", "dur_detail_selected_id_", "dur_detail_selected_item_"}};
    private Integer mId;
    private Integer mDefId;
    private List<ItemName> mItemName = new ArrayList<ItemName>();
    private List<DetailSetting> mDetailSetting = new ArrayList<DetailSetting>();

    public void setId(Integer id) {
        this.mId = id;
    }

    public Integer getId() {
        return this.mId;
    }

    public void setDefId(Integer defid) {
        this.mDefId = defid;
    }

    public Integer getDefId() {
        return this.mDefId;
    }

    public void setItemName(ItemName itemname) {
        this.mItemName.add(itemname);
    }

    public List<ItemName> getItemName() {
        return this.mItemName;
    }

    public void setDetailSetting(DetailSetting detailsetting) {
        this.mDetailSetting.add(detailsetting);
    }

    public List<DetailSetting> getDetailSetting() {
        return this.mDetailSetting;
    }

    public void setIlluminationPatternInfo(Cursor cursor) {
        this.setInformationData(cursor, 0);
    }

    public void setIlluminationColorInfo(Cursor cursor) {
        this.setInformationData(cursor, 1);
    }

    public void setBeepInfo(Cursor cursor) {
        this.setInformationData(cursor, 2);
    }

    public void setVibrationInfo(Cursor cursor) {
        this.setInformationData(cursor, 3);
    }

    public void setDurationInfo(Cursor cursor) {
        this.setInformationData(cursor, 4);
    }

    public void setInformationData(Cursor cursor, int type) {
        int colId = cursor.getColumnIndex(mColName[type][0]);
        if (!cursor.isNull(colId)) {
            this.setId(cursor.getInt(colId));
        }
        if (!cursor.isNull(colId = cursor.getColumnIndex(mColName[type][1]))) {
            this.setDefId(cursor.getInt(colId));
        }
        ItemName name_ja = new ItemName();
        name_ja.setLanguage(LANG_JA);
        colId = cursor.getColumnIndex(mColName[type][2]);
        if (!cursor.isNull(colId)) {
            name_ja.setItemName(cursor.getString(colId));
        }
        this.setItemName(name_ja);
        ItemName name_en = new ItemName();
        name_en.setLanguage(LANG_EN);
        colId = cursor.getColumnIndex(mColName[type][3]);
        if (!cursor.isNull(colId)) {
            name_en.setItemName(cursor.getString(colId));
        }
        this.setItemName(name_en);
        colId = cursor.getColumnIndex(mColName[type][4]);
        if (!cursor.isNull(colId)) {
            int detailNum = cursor.getInt(colId);
            for (int i = 0; i < detailNum; ++i) {
                DetailSetting detailSetting = new DetailSetting();
                colId = cursor.getColumnIndex(mColName[type][5] + (i + 1));
                if (!cursor.isNull(colId)) {
                    detailSetting.setSelectedId(cursor.getInt(colId));
                }
                ItemName detailItemName = new ItemName();
                detailItemName.setLanguage(LANG_JA);
                colId = cursor.getColumnIndex(mColName[type][6] + (i + 1));
                if (!cursor.isNull(colId)) {
                    detailItemName.setItemName(cursor.getString(colId));
                }
                detailSetting.setItemName(detailItemName);
                this.setDetailSetting(detailSetting);
            }
        }
    }
}

