/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.android.sdaiflib;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import com.nttdocomo.android.sdaiflib.NotifyRange;
import com.nttdocomo.android.sdaiflib.Utils;

public class ReceiveRange
extends BroadcastReceiver {
    private static final String TAG = "Receiver_range";
    private NotifyRange.RangeInterface mObserver;

    public ReceiveRange(NotifyRange.RangeInterface observer) {
        this.mObserver = observer;
        if (observer == null) {
            Log.d((String)TAG, (String)"observer null");
        }
    }

    public ReceiveRange() {
        this.mObserver = null;
    }

    public void onReceive(Context context, Intent intent) {
        String action;
        Log.d((String)TAG, (String)intent.toString());
        Bundle extra = intent.getExtras();
        if (extra != null) {
            Log.d((String)TAG, (String)intent.getExtras().toString());
        }
        if ((action = intent.getAction()) == null) {
            return;
        }
        if (this.mObserver == null) {
            Log.d((String)TAG, (String)"ERROR:observer null");
        }
        if ("com.nttdocomo.android.smartdeviceagent.action.RANGE_CHANGE".equals(action)) {
            Log.d((String)TAG, (String)"write!");
            SharedPreferences preference = context.getSharedPreferences("RangeInformation", 0);
            SharedPreferences.Editor editor = preference.edit();
            editor.putLong("RECEIVE_TIME", Utils.getCurrentTimeLong());
            editor.putInt("DEVICE_ID", intent.getIntExtra("com.nttdocomo.android.smartdeviceagent.extra.DEVICE_ID", -1));
            editor.putInt("DEVICE_UID", intent.getIntExtra("com.nttdocomo.android.smartdeviceagent.extra.DEVICE_UID", -1));
            editor.putString("BD_ADDRESS", intent.getStringExtra("com.nttdocomo.android.smartdeviceagent.extra.BD_ADDRESS"));
            editor.putInt("RANGE", intent.getIntExtra("com.nttdocomo.android.smartdeviceagent.extra.RANGE", -1));
            editor.putInt("RANGE_SETTING", intent.getIntExtra("com.nttdocomo.android.smartdeviceagent.extra.RANGE_SETTING", -1));
            editor.commit();
            if (this.mObserver != null) {
                this.mObserver.onRangeChange();
            }
        }
    }
}

