/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.android.sdaiflib;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.nttdocomo.android.sdaiflib.SendMail;
import java.util.HashMap;
import java.util.Map;

public class ReceiveSendMailResult {
    private static ReceiveSendMailResult sInstance;
    private Context mContext;
    private long mId = 0L;
    private BroadcastReceiver mReceiver;
    private Map<Long, SendMail.SendMailResultInterface> mCallbackMap = new HashMap<Long, SendMail.SendMailResultInterface>();

    public Long getSequenceId() {
        Long id = this.mId;
        this.mId = this.mId != Long.MAX_VALUE ? ++this.mId : 0L;
        return id;
    }

    public void addCallback(Long id, SendMail.SendMailResultInterface observer) {
        this.mCallbackMap.put(id, observer);
    }

    public void delCallback(Long id) {
        this.mCallbackMap.remove(id);
        if ((this.mCallbackMap == null || this.mCallbackMap.size() == 0) && this.mContext != null && this.mReceiver != null) {
            try {
                this.mContext.unregisterReceiver(this.mReceiver);
                this.mReceiver = null;
                this.delInstance();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static synchronized ReceiveSendMailResult getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new ReceiveSendMailResult(context.getApplicationContext());
        }
        return sInstance;
    }

    private synchronized void delInstance() {
        sInstance = null;
    }

    private ReceiveSendMailResult(Context context) {
        this.mContext = context;
        IntentFilter filter = new IntentFilter();
        filter.addAction("com.nttdocomo.android.smartdeviceagent.action.RECEIVED_MAIL_RESULT");
        this.mReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action == null) {
                    return;
                }
                if (ReceiveSendMailResult.this.mCallbackMap != null && ReceiveSendMailResult.this.mCallbackMap.size() != 0 && "com.nttdocomo.android.smartdeviceagent.action.RECEIVED_MAIL_RESULT".equals(action)) {
                    int result = intent.getIntExtra("com.nttdocomo.android.smartdeviceagent.extra.RESULT", -1);
                    int[] uidList = intent.getIntArrayExtra("com.nttdocomo.android.smartdeviceagent.extra.DEVICE_UID");
                    int uid = -1;
                    if (uidList != null) {
                        uid = uidList[0];
                    }
                    for (Map.Entry map : ReceiveSendMailResult.this.mCallbackMap.entrySet()) {
                        Long id = intent.getLongExtra("com.nttdocomo.android.smartdeviceagent.extra.SEQUENCE_ID", -1L);
                        if (map.getKey() != id) continue;
                        ((SendMail.SendMailResultInterface)map.getValue()).onSendMailResult(result, uid);
                        return;
                    }
                }
            }
        };
        this.mContext.registerReceiver(this.mReceiver, filter);
    }
}

