/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.android.sdaiflib;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.nttdocomo.android.sdaiflib.ReceiveSendMailResult;
import com.nttdocomo.android.sdaiflib.SendBase;

public class SendMail
extends SendBase {
    private static final String ACTION_SUFFIX = ".sda.action.RECEIVED_MAIL";
    private static final String Tag = "SDALib_Mail";
    private static final int RESULT_PARAM_ADDRESS_NG = 2305;
    private static final int RESULT_PARAM_RECEIVETIME_NG = 2306;
    private Context mContext;
    public long mId = -1L;
    public String mTitle = null;
    public String mText = null;
    public String mAddress = null;
    public String mSendUser = null;
    public long mReceiveTime = -1L;
    private ReceiveSendMailResult mReceiver;

    public SendMail() {
        this.mContext = null;
    }

    public SendMail(Context context) {
        this.mContext = context;
    }

    public SendMail(Context context, SendMailResultInterface resultObserver) {
        this.mContext = context;
        this.mReceiver = ReceiveSendMailResult.getInstance(context);
        this.mId = this.mReceiver.getSequenceId();
        this.mReceiver.addCallback(this.mId, resultObserver);
    }

    public boolean setTitle(String title) {
        if (title == null || title.equals("")) {
            return false;
        }
        this.mTitle = title;
        return true;
    }

    public boolean setText(String text) {
        if (text == null || text.equals("")) {
            return false;
        }
        this.mText = text;
        return true;
    }

    public boolean setAddress(String address) {
        if (address == null || address.equals("")) {
            return false;
        }
        this.mAddress = address;
        return true;
    }

    public boolean setSendUser(String sendUser) {
        if (sendUser == null || sendUser.equals("")) {
            return false;
        }
        this.mSendUser = sendUser;
        return true;
    }

    public boolean setReceiveTime(long receiveTime) {
        if (receiveTime < 0L) {
            return false;
        }
        this.mReceiveTime = receiveTime;
        return true;
    }

    public int send(String address, long receiveTime) {
        if (!this.setAddress(address)) {
            return 2305;
        }
        if (!this.setReceiveTime(receiveTime)) {
            return 2306;
        }
        return this.send();
    }

    public int send() {
        Intent intent = new Intent(this.mContext.getPackageName() + ACTION_SUFFIX);
        intent.setClassName("com.nttdocomo.android.smartdeviceagent", "com.nttdocomo.android.smartdeviceagent.RequestReceiver");
        intent.putExtra(this.makeExtraName("MAIL_ADDRESS"), this.mAddress);
        intent.putExtra(this.makeExtraName("RECEIVED_TIME"), this.mReceiveTime);
        if (this.mDispNameJa != null && this.mDispNameJa != "") {
            intent.putExtra(this.makeExtraName("NAME_JA"), this.mDispNameJa);
        }
        if (this.mDispNameEn != null && this.mDispNameEn != "") {
            intent.putExtra(this.makeExtraName("NAME_EN"), this.mDispNameEn);
        }
        if (this.mTitle != null && this.mTitle != "") {
            intent.putExtra(this.makeExtraName("TITLE"), this.mTitle);
        }
        if (this.mText != null && this.mText != "") {
            intent.putExtra(this.makeExtraName("TEXT"), this.mText);
        }
        if (this.mSendUser != null && this.mSendUser != "") {
            intent.putExtra(this.makeExtraName("NAME"), this.mSendUser);
        }
        if (this.mNotificationID >= 0 && this.mNotificationID <= 65535) {
            intent.putExtra(this.makeExtraName("NOTIFICATION_ID"), this.mNotificationID);
        }
        if (this.mCategoryID >= 0 && this.mCategoryID <= 65535) {
            intent.putExtra(this.makeExtraName("NOTIFICATION_CATEGORY_ID"), this.mCategoryID);
        }
        if (this.mRingtone != null) {
            intent.putExtra(this.makeExtraName("RINGTONE"), this.mRingtone);
        }
        if (this.mIllumination != null) {
            intent.putExtra(this.makeExtraName("ILLUMINATION"), this.mIllumination);
        }
        if (this.mVibration != null) {
            intent.putExtra(this.makeExtraName("VIBRATION"), this.mVibration);
        }
        if (this.mDuration != null) {
            intent.putExtra(this.makeExtraName("DURATION"), this.mDuration);
        }
        if (this.deviceID_flag) {
            intent.putExtra(this.makeExtraName("DEVICE_ID"), this.mDeviceID);
        }
        if (this.mDeviceUID != null) {
            intent.putExtra(this.makeExtraName("DEVICE_UID"), this.mDeviceUID);
        }
        Log.d((String)Tag, (String)intent.toString());
        if (intent.getExtras() != null) {
            Log.d((String)Tag, (String)intent.getExtras().toString());
        }
        if (this.mContext == null) {
            return 1025;
        }
        this.mContext.sendBroadcast(intent);
        return -1;
    }

    public int sendWithResponse(int uid) {
        Intent intent = new Intent(this.mContext.getPackageName() + ACTION_SUFFIX);
        intent.setClassName("com.nttdocomo.android.smartdeviceagent", "com.nttdocomo.android.smartdeviceagent.RequestReceiver");
        intent.putExtra(this.makeExtraName("MAIL_ADDRESS"), this.mAddress);
        intent.putExtra(this.makeExtraName("RECEIVED_TIME"), this.mReceiveTime);
        if (this.mDispNameJa != null && this.mDispNameJa != "") {
            intent.putExtra(this.makeExtraName("NAME_JA"), this.mDispNameJa);
        }
        if (this.mDispNameEn != null && this.mDispNameEn != "") {
            intent.putExtra(this.makeExtraName("NAME_EN"), this.mDispNameEn);
        }
        if (this.mTitle != null && this.mTitle != "") {
            intent.putExtra(this.makeExtraName("TITLE"), this.mTitle);
        }
        if (this.mText != null && this.mText != "") {
            intent.putExtra(this.makeExtraName("TEXT"), this.mText);
        }
        if (this.mSendUser != null && this.mSendUser != "") {
            intent.putExtra(this.makeExtraName("NAME"), this.mSendUser);
        }
        if (this.mNotificationID >= 0 && this.mNotificationID <= 65535) {
            intent.putExtra(this.makeExtraName("NOTIFICATION_ID"), this.mNotificationID);
        }
        if (this.mCategoryID >= 0 && this.mCategoryID <= 65535) {
            intent.putExtra(this.makeExtraName("NOTIFICATION_CATEGORY_ID"), this.mCategoryID);
        }
        if (this.mRingtone != null) {
            intent.putExtra(this.makeExtraName("RINGTONE"), this.mRingtone);
        }
        if (this.mIllumination != null) {
            intent.putExtra(this.makeExtraName("ILLUMINATION"), this.mIllumination);
        }
        if (this.mVibration != null) {
            intent.putExtra(this.makeExtraName("VIBRATION"), this.mVibration);
        }
        if (this.mDuration != null) {
            intent.putExtra(this.makeExtraName("DURATION"), this.mDuration);
        }
        if (this.deviceID_flag) {
            intent.putExtra(this.makeExtraName("DEVICE_ID"), this.mDeviceID);
        }
        int[] uidList = new int[]{uid};
        intent.putExtra(this.makeExtraName("DEVICE_UID"), uidList);
        intent.putExtra(this.makeExtraName("NOTIFICATION_WITH_RESP"), true);
        intent.putExtra(this.makeExtraName("SEQUENCE_ID"), this.mId);
        Log.d((String)Tag, (String)intent.toString());
        if (intent.getExtras() != null) {
            Log.d((String)Tag, (String)intent.getExtras().toString());
        }
        if (this.mContext == null) {
            return 1025;
        }
        this.mContext.sendBroadcast(intent);
        return -1;
    }

    @Override
    public void clear() {
        super.clear();
        this.mTitle = null;
        this.mText = null;
        this.mAddress = null;
        this.mSendUser = null;
        this.mReceiveTime = -1L;
    }

    private String makeExtraName(String name) {
        return this.mContext.getPackageName() + ".sda.extra." + name;
    }

    public void release() {
        if (this.mContext != null && this.mReceiver != null) {
            this.mReceiver.delCallback(this.mId);
            this.mReceiver = null;
        }
    }

    public static interface SendMailResultInterface {
        public void onSendMailResult(int var1, int var2);
    }
}

