/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.android.sdaiflib;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.nttdocomo.android.sdaiflib.ReceiveSendNotificationResult;
import com.nttdocomo.android.sdaiflib.SendBase;

public class SendNotification
extends SendBase {
    private static final String ACTION_SUFFIX = ".sda.action.NOTIFICATION";
    private static final String Tag = "SDALib_Notification";
    private Context mContext;
    public long mId = -1L;
    public String mTitle = null;
    public String mText = null;
    public int mIcon = 0;
    private ReceiveSendNotificationResult mReceiver;

    public SendNotification() {
        this.mContext = null;
    }

    public SendNotification(Context context) {
        this.mContext = context;
    }

    public SendNotification(Context context, SendNotificationResultInterface resultObserver) {
        this.mContext = context;
        this.mReceiver = ReceiveSendNotificationResult.getInstance(context);
        this.mId = this.mReceiver.getSequenceId();
        this.mReceiver.addCallback(this.mId, resultObserver);
    }

    public boolean setTitle(String title) {
        if (title == null || title.equals("")) {
            return false;
        }
        this.mTitle = title;
        return true;
    }

    public boolean setText(String text) {
        if (text == null || text.equals("")) {
            return false;
        }
        this.mText = text;
        return true;
    }

    public boolean setIcon(int icon) {
        if (icon == 0) {
            return false;
        }
        this.mIcon = icon;
        return true;
    }

    public int send(String text) {
        if (this.setText(text)) {
            return this.send();
        }
        return 1026;
    }

    public int send() {
        Intent intent = new Intent(this.mContext.getPackageName() + ACTION_SUFFIX);
        intent.setClassName("com.nttdocomo.android.smartdeviceagent", "com.nttdocomo.android.smartdeviceagent.RequestReceiver");
        intent.putExtra(this.makeExtraName("TEXT"), this.mText);
        if (this.mDispNameJa != null && this.mDispNameJa != "") {
            intent.putExtra(this.makeExtraName("NAME_JA"), this.mDispNameJa);
        }
        if (this.mDispNameEn != null && this.mDispNameEn != "") {
            intent.putExtra(this.makeExtraName("NAME_EN"), this.mDispNameEn);
        }
        if (this.mTitle != null && this.mTitle != "") {
            intent.putExtra(this.makeExtraName("TITLE"), this.mTitle);
        }
        if (this.mIcon != 0) {
            intent.putExtra(this.makeExtraName("ICON"), this.mIcon);
        }
        if (this.mNotificationID >= 0 && this.mNotificationID <= 65535) {
            intent.putExtra(this.makeExtraName("NOTIFICATION_ID"), this.mNotificationID);
        }
        if (this.mCategoryID >= 0 && this.mCategoryID <= 65535) {
            intent.putExtra(this.makeExtraName("NOTIFICATION_CATEGORY_ID"), this.mCategoryID);
        }
        if (this.mRingtone != null) {
            intent.putExtra(this.makeExtraName("RINGTONE"), this.mRingtone);
        }
        if (this.mIllumination != null) {
            intent.putExtra(this.makeExtraName("ILLUMINATION"), this.mIllumination);
        }
        if (this.mVibration != null) {
            intent.putExtra(this.makeExtraName("VIBRATION"), this.mVibration);
        }
        if (this.mBeep != null) {
            intent.putExtra(this.makeExtraName("BEEP"), this.mBeep);
        }
        if (this.mDuration != null) {
            intent.putExtra(this.makeExtraName("DURATION"), this.mDuration);
        }
        if (this.deviceID_flag) {
            intent.putExtra(this.makeExtraName("DEVICE_ID"), this.mDeviceID);
        }
        if (this.mDeviceUID != null) {
            intent.putExtra(this.makeExtraName("DEVICE_UID"), this.mDeviceUID);
        }
        Log.d((String)Tag, (String)intent.toString());
        if (intent.getExtras() != null) {
            Log.d((String)Tag, (String)intent.getExtras().toString());
        }
        if (this.mContext == null) {
            return 1025;
        }
        this.mContext.sendBroadcast(intent);
        return -1;
    }

    public int sendWithResponse(int uid) {
        Intent intent = new Intent(this.mContext.getPackageName() + ACTION_SUFFIX);
        intent.setClassName("com.nttdocomo.android.smartdeviceagent", "com.nttdocomo.android.smartdeviceagent.RequestReceiver");
        intent.putExtra(this.makeExtraName("TEXT"), this.mText);
        if (this.mDispNameJa != null && this.mDispNameJa != "") {
            intent.putExtra(this.makeExtraName("NAME_JA"), this.mDispNameJa);
        }
        if (this.mDispNameEn != null && this.mDispNameEn != "") {
            intent.putExtra(this.makeExtraName("NAME_EN"), this.mDispNameEn);
        }
        if (this.mTitle != null && this.mTitle != "") {
            intent.putExtra(this.makeExtraName("TITLE"), this.mTitle);
        }
        if (this.mIcon != 0) {
            intent.putExtra(this.makeExtraName("ICON"), this.mIcon);
        }
        if (this.mNotificationID >= 0 && this.mNotificationID <= 65535) {
            intent.putExtra(this.makeExtraName("NOTIFICATION_ID"), this.mNotificationID);
        }
        if (this.mCategoryID >= 0 && this.mCategoryID <= 65535) {
            intent.putExtra(this.makeExtraName("NOTIFICATION_CATEGORY_ID"), this.mCategoryID);
        }
        if (this.mRingtone != null) {
            intent.putExtra(this.makeExtraName("RINGTONE"), this.mRingtone);
        }
        if (this.mIllumination != null) {
            intent.putExtra(this.makeExtraName("ILLUMINATION"), this.mIllumination);
        }
        if (this.mVibration != null) {
            intent.putExtra(this.makeExtraName("VIBRATION"), this.mVibration);
        }
        if (this.mBeep != null) {
            intent.putExtra(this.makeExtraName("BEEP"), this.mBeep);
        }
        if (this.mDuration != null) {
            intent.putExtra(this.makeExtraName("DURATION"), this.mDuration);
        }
        if (this.deviceID_flag) {
            intent.putExtra(this.makeExtraName("DEVICE_ID"), this.mDeviceID);
        }
        int[] uidList = new int[]{uid};
        intent.putExtra(this.makeExtraName("DEVICE_UID"), uidList);
        intent.putExtra(this.makeExtraName("NOTIFICATION_WITH_RESP"), true);
        intent.putExtra(this.makeExtraName("SEQUENCE_ID"), this.mId);
        Log.d((String)Tag, (String)intent.toString());
        if (intent.getExtras() != null) {
            Log.d((String)Tag, (String)intent.getExtras().toString());
        }
        if (this.mContext == null) {
            return 1025;
        }
        this.mContext.sendBroadcast(intent);
        return -1;
    }

    @Override
    public void clear() {
        super.clear();
        this.mTitle = null;
        this.mText = null;
        this.mIcon = 0;
    }

    private String makeExtraName(String name) {
        return this.mContext.getPackageName() + ".sda.extra." + name;
    }

    public void release() {
        if (this.mContext != null && this.mReceiver != null) {
            this.mReceiver.delCallback(this.mId);
            this.mReceiver = null;
        }
    }

    public static interface SendNotificationResultInterface {
        public void onSendNotificationResult(int var1, int var2);
    }
}

