/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.android.sdaiflib;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.nttdocomo.android.sdaiflib.ReceiveSendScheduleResult;
import com.nttdocomo.android.sdaiflib.SendBase;

public class SendSchedule
extends SendBase {
    private static final String ACTION_SUFFIX = ".sda.action.SCHEDULE";
    private static final String Tag = "SDALib_Schedule";
    public static final int RESULT_PARAM_TITLE_NG = 2305;
    private static final int RESULT_PARAM_TIME_NG = 2306;
    private Context mContext;
    public long mId = -1L;
    public String mTitle = null;
    public long mStartTime = -1L;
    public long mEndTime = -1L;
    public String mWhere = null;
    public String mPerson = null;
    public String mDescription = null;
    public byte[] mContent1 = null;
    public byte[] mContent2 = null;
    public byte[] mContent3 = null;
    private ReceiveSendScheduleResult mReceiver;

    public SendSchedule() {
        this.mContext = null;
    }

    public SendSchedule(Context context) {
        this.mContext = context;
    }

    public SendSchedule(Context context, SendScheduleResultInterface resultObserver) {
        this.mContext = context;
        this.mReceiver = ReceiveSendScheduleResult.getInstance(context);
        this.mId = this.mReceiver.getSequenceId();
        this.mReceiver.addCallback(this.mId, resultObserver);
    }

    public boolean setTitle(String title) {
        if (title == null || title.equals("")) {
            return false;
        }
        this.mTitle = title;
        return true;
    }

    public boolean setStartTime(long startTime) {
        if (startTime < 0L) {
            return false;
        }
        this.mStartTime = startTime;
        return true;
    }

    public boolean setEndTime(long endTime) {
        if (endTime < 0L) {
            return false;
        }
        this.mEndTime = endTime;
        return true;
    }

    public boolean setWhere(String where) {
        if (where == null || where.equals("")) {
            return false;
        }
        this.mWhere = where;
        return true;
    }

    public boolean setPerson(String person) {
        if (person == null || person.equals("")) {
            return false;
        }
        this.mPerson = person;
        return true;
    }

    public boolean setDescription(String description) {
        if (description == null || description.equals("")) {
            return false;
        }
        this.mDescription = description;
        return true;
    }

    public boolean setContent1(byte[] content1) {
        if (content1 == null) {
            return false;
        }
        int cnt = content1.length;
        this.mContent1 = new byte[cnt];
        for (int i = 0; i < cnt; ++i) {
            this.mContent1[i] = content1[i];
        }
        return true;
    }

    public boolean setContent2(byte[] content2) {
        if (content2 == null) {
            return false;
        }
        int cnt = content2.length;
        this.mContent2 = new byte[cnt];
        for (int i = 0; i < cnt; ++i) {
            this.mContent2[i] = content2[i];
        }
        return true;
    }

    public boolean setContent3(byte[] content3) {
        if (content3 == null) {
            return false;
        }
        int cnt = content3.length;
        this.mContent3 = new byte[cnt];
        for (int i = 0; i < cnt; ++i) {
            this.mContent3[i] = content3[i];
        }
        return true;
    }

    public int send(String title, long startTime) {
        if (!this.setTitle(title)) {
            return 2305;
        }
        if (!this.setStartTime(startTime)) {
            return 2306;
        }
        return this.send();
    }

    public int send() {
        Intent intent = new Intent(this.mContext.getPackageName() + ACTION_SUFFIX);
        intent.setClassName("com.nttdocomo.android.smartdeviceagent", "com.nttdocomo.android.smartdeviceagent.RequestReceiver");
        intent.putExtra(this.makeExtraName("TITLE"), this.mTitle);
        intent.putExtra(this.makeExtraName("START_TIME"), this.mStartTime);
        if (this.mDispNameJa != null && this.mDispNameJa != "") {
            intent.putExtra(this.makeExtraName("NAME_JA"), this.mDispNameJa);
        }
        if (this.mDispNameEn != null && this.mDispNameEn != "") {
            intent.putExtra(this.makeExtraName("NAME_EN"), this.mDispNameEn);
        }
        if (this.mEndTime > 0L) {
            intent.putExtra(this.makeExtraName("END_TIME"), this.mEndTime);
        }
        if (this.mWhere != null && this.mWhere != "") {
            intent.putExtra(this.makeExtraName("WHERE"), this.mWhere);
        }
        if (this.mPerson != null && this.mPerson != "") {
            intent.putExtra(this.makeExtraName("PERSON"), this.mPerson);
        }
        if (this.mDescription != null && this.mDescription != "") {
            intent.putExtra(this.makeExtraName("DESCRIPTION"), this.mDescription);
        }
        if (this.mContent1 != null) {
            intent.putExtra(this.makeExtraName("CONTENT_1"), this.mContent1);
        }
        if (this.mContent2 != null) {
            intent.putExtra(this.makeExtraName("CONTENT_2"), this.mContent2);
        }
        if (this.mContent3 != null) {
            intent.putExtra(this.makeExtraName("CONTENT_3"), this.mContent3);
        }
        if (this.mNotificationID >= 0 && this.mNotificationID <= 65535) {
            intent.putExtra(this.makeExtraName("NOTIFICATION_ID"), this.mNotificationID);
        }
        if (this.mCategoryID >= 0 && this.mCategoryID <= 65535) {
            intent.putExtra(this.makeExtraName("NOTIFICATION_CATEGORY_ID"), this.mCategoryID);
        }
        if (this.mRingtone != null) {
            intent.putExtra(this.makeExtraName("RINGTONE"), this.mRingtone);
        }
        if (this.mIllumination != null) {
            intent.putExtra(this.makeExtraName("ILLUMINATION"), this.mIllumination);
        }
        if (this.mVibration != null) {
            intent.putExtra(this.makeExtraName("VIBRATION"), this.mVibration);
        }
        if (this.mDuration != null) {
            intent.putExtra(this.makeExtraName("DURATION"), this.mDuration);
        }
        if (this.deviceID_flag) {
            intent.putExtra(this.makeExtraName("DEVICE_ID"), this.mDeviceID);
        }
        if (this.mDeviceUID != null) {
            intent.putExtra(this.makeExtraName("DEVICE_UID"), this.mDeviceUID);
        }
        Log.d((String)Tag, (String)intent.toString());
        if (intent.getExtras() != null) {
            Log.d((String)Tag, (String)intent.getExtras().toString());
        }
        if (this.mContext == null) {
            return 1025;
        }
        this.mContext.sendBroadcast(intent);
        return -1;
    }

    public int sendWithResponse(int uid) {
        Intent intent = new Intent(this.mContext.getPackageName() + ACTION_SUFFIX);
        intent.setClassName("com.nttdocomo.android.smartdeviceagent", "com.nttdocomo.android.smartdeviceagent.RequestReceiver");
        intent.putExtra(this.makeExtraName("TITLE"), this.mTitle);
        intent.putExtra(this.makeExtraName("START_TIME"), this.mStartTime);
        if (this.mDispNameJa != null && this.mDispNameJa != "") {
            intent.putExtra(this.makeExtraName("NAME_JA"), this.mDispNameJa);
        }
        if (this.mDispNameEn != null && this.mDispNameEn != "") {
            intent.putExtra(this.makeExtraName("NAME_EN"), this.mDispNameEn);
        }
        if (this.mEndTime > 0L) {
            intent.putExtra(this.makeExtraName("END_TIME"), this.mEndTime);
        }
        if (this.mWhere != null && this.mWhere != "") {
            intent.putExtra(this.makeExtraName("WHERE"), this.mWhere);
        }
        if (this.mPerson != null && this.mPerson != "") {
            intent.putExtra(this.makeExtraName("PERSON"), this.mPerson);
        }
        if (this.mDescription != null && this.mDescription != "") {
            intent.putExtra(this.makeExtraName("DESCRIPTION"), this.mDescription);
        }
        if (this.mContent1 != null) {
            intent.putExtra(this.makeExtraName("CONTENT_1"), this.mContent1);
        }
        if (this.mContent2 != null) {
            intent.putExtra(this.makeExtraName("CONTENT_2"), this.mContent2);
        }
        if (this.mContent3 != null) {
            intent.putExtra(this.makeExtraName("CONTENT_3"), this.mContent3);
        }
        if (this.mNotificationID >= 0 && this.mNotificationID <= 65535) {
            intent.putExtra(this.makeExtraName("NOTIFICATION_ID"), this.mNotificationID);
        }
        if (this.mCategoryID >= 0 && this.mCategoryID <= 65535) {
            intent.putExtra(this.makeExtraName("NOTIFICATION_CATEGORY_ID"), this.mCategoryID);
        }
        if (this.mRingtone != null) {
            intent.putExtra(this.makeExtraName("RINGTONE"), this.mRingtone);
        }
        if (this.mIllumination != null) {
            intent.putExtra(this.makeExtraName("ILLUMINATION"), this.mIllumination);
        }
        if (this.mVibration != null) {
            intent.putExtra(this.makeExtraName("VIBRATION"), this.mVibration);
        }
        if (this.mDuration != null) {
            intent.putExtra(this.makeExtraName("DURATION"), this.mDuration);
        }
        if (this.deviceID_flag) {
            intent.putExtra(this.makeExtraName("DEVICE_ID"), this.mDeviceID);
        }
        int[] uidList = new int[]{uid};
        intent.putExtra(this.makeExtraName("DEVICE_UID"), uidList);
        intent.putExtra(this.makeExtraName("NOTIFICATION_WITH_RESP"), true);
        intent.putExtra(this.makeExtraName("SEQUENCE_ID"), this.mId);
        Log.d((String)Tag, (String)intent.toString());
        if (intent.getExtras() != null) {
            Log.d((String)Tag, (String)intent.getExtras().toString());
        }
        if (this.mContext == null) {
            return 1025;
        }
        this.mContext.sendBroadcast(intent);
        return -1;
    }

    @Override
    public void clear() {
        super.clear();
        this.mTitle = null;
        this.mStartTime = -1L;
        this.mEndTime = -1L;
        this.mWhere = null;
        this.mPerson = null;
        this.mDescription = null;
        this.mContent1 = null;
        this.mContent2 = null;
        this.mContent3 = null;
    }

    private String makeExtraName(String name) {
        return this.mContext.getPackageName() + ".sda.extra." + name;
    }

    public void release() {
        if (this.mContext != null && this.mReceiver != null) {
            this.mReceiver.delCallback(this.mId);
            this.mReceiver = null;
        }
    }

    public static interface SendScheduleResultInterface {
        public void onSendScheduleResult(int var1, int var2);
    }
}

