/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.android.sdaiflib;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class Utils {
    public static final String DEFAULT_TIME_FORMAT = "yyyy/MM/dd HH:mm";
    public static final String DEFAULT_TIME_FORMAT_EX = "yyyy/MM/dd HH:mm:ss.SSS";

    public static long getTimeLong(String date, String format) {
        SimpleDateFormat sd = new SimpleDateFormat(format);
        Date d = null;
        try {
            d = sd.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return -1L;
        }
        Calendar cl = Calendar.getInstance();
        cl.setTime(d);
        return cl.getTimeInMillis();
    }

    public static long getTimeLong(String date) {
        return Utils.getTimeLong(date, DEFAULT_TIME_FORMAT);
    }

    public static long getCurrentTimeLong() {
        Calendar cl = Calendar.getInstance();
        return cl.getTimeInMillis();
    }

    public static String getCurrentTimeString() {
        return Utils.getCurrentTimeString(DEFAULT_TIME_FORMAT);
    }

    public static String getCurrentTimeString(String format) {
        Calendar cl = Calendar.getInstance();
        Date date = cl.getTime();
        SimpleDateFormat sd = new SimpleDateFormat(format);
        String dateStr = sd.format(date);
        return dateStr;
    }

    public static String getTimeString(long milliseconds) {
        return Utils.getTimeString(milliseconds, DEFAULT_TIME_FORMAT);
    }

    public static String getTimeStringEx(long milliseconds) {
        return Utils.getTimeString(milliseconds, DEFAULT_TIME_FORMAT_EX);
    }

    public static String getTimeString(long milliseconds, String format) {
        Date date = new Date();
        date.setTime(milliseconds);
        SimpleDateFormat sd = new SimpleDateFormat(format);
        String dateStr = sd.format(date);
        return dateStr;
    }

    public static String getIntExtraToString(Intent intent, String key) {
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            return "";
        }
        if (!bundle.containsKey(key)) {
            return "";
        }
        int val = bundle.getInt(key);
        return String.valueOf(val);
    }

    public static String getLongExtraToString(Intent intent, String key) {
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            return "";
        }
        if (!bundle.containsKey(key)) {
            return "";
        }
        long val = bundle.getLong(key);
        return String.valueOf(val);
    }

    public static String getDoubleExtraToString(Intent intent, String key) {
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            return "";
        }
        if (!bundle.containsKey(key)) {
            return "";
        }
        double val = bundle.getDouble(key);
        return String.valueOf(val);
    }

    static boolean checkSdaVersion(Context context, int targetVersion) {
        int sdaVersion = Utils.getApplicationVersion(context, "com.nttdocomo.android.smartdeviceagent");
        return (sdaVersion %= 10000) >= targetVersion;
    }

    static int getApplicationVersion(Context context, String packageName) {
        int versionCode;
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            versionCode = pi.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            versionCode = -1;
        }
        return versionCode;
    }
}

