package jp.agentec.abook.abv.bl.acms.client.json;

import java.util.Date;

import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.common.util.JsonUtil;
import jp.agentec.abook.abv.bl.data.ABVDataCache;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

import org.json.adf.JSONException;
import org.json.adf.JSONObject;

/**
 * ACMSからのJSONに共通的に格納される項目を持っています。JSONに対応するクラスを作成するときはこのクラスを継承してください。
 * @author Taejin Hong
 * @version　1.0.0 
 */
public class AcmsCommonJSON extends AcmsJSONParser {
	public static final String HttpStatus = "httpStatus";
	public static final String PresentTime = "presentTime";
	public static final String PresentTimeUTC = "presentTimeUTC";

	public int httpStatus; // ACMSが返したHTTP statusコード
	public Date presentTime;// サーバーの現在時刻を取得します。サーバーの時間取得において、何らかの問題があった場合、nullを返します。
	
	public AcmsCommonJSON(String jsonString) throws AcmsException {
		super(jsonString);
	}
	
	@Override
	protected void parse(JSONObject json) throws JSONValidationException, JSONException {
		httpStatus = getInt(json, HttpStatus);
		String time = JsonUtil.getString(json, PresentTime);
		presentTime = DateTimeUtil.toDate(time, DateTimeFormat.yyyyMMddHHmmss_hyphen);
		ABVDataCache.getInstance().setLastPresentTime(presentTime);
	}
}
