package jp.agentec.abook.abv.bl.acms.client.json;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.common.util.JsonUtil;
import jp.agentec.abook.abv.bl.dto.ContentDto;
import jp.agentec.abook.abv.bl.dto.SppDeviceDto;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

/**
 * {@link AcmsClient#contentVersion} の戻り値です。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class ContentVersionsJSON extends AcmsCommonJSON {
	public static final String ContentList = "contentList";
	public static final String ContentId = "contentId";
	public static final String MetaVersion = "metaVersion";
	public static final String ResourceVersion = "resourceVersion";
	public static final String ContentNameKana = "contentNameKana";
	public static final String ContentType = "contentType";
    public static final String FetchDate = "fetchDate";

    // SPP通信の端末情報リスト
    public static final String SppDeviceInfoList = "sppDeviceInfoList";
	public static final String SppDeviceId = "sppDeviceId";
	public static final String SppDeviceName = "sppDeviceName";
	public static final String DataStartIndex = "dataStartIndex";
	public static final String DataEndIndex = "dataEndIndex";

	
	public ArrayList<ContentDto> contentVersions;
    public String fetchDate;

    // SPP通信機器のDTOリスト
    public List<SppDeviceDto> sppDeviceDtoList;

	public static final String ResourcePatternType = "resourcePatternType"; // 文言リソースパターン
	public int resourcePatternType;  // 文言リソースパターン変数

	public ContentVersionsJSON(String jsonString) throws AcmsException {
		super(jsonString);
	}
	
	@Override
	protected void parse(JSONObject json) throws JSONValidationException {
		// 取得したJSONから事業者リソースパターンを取得する
		if (json.has(ResourcePatternType)) {
			resourcePatternType = json.getInt(ResourcePatternType);
		}
		if (json.has(FetchDate)) {
            fetchDate = json.getString(FetchDate);
        }

        // SppDeviceInfoListキーが存在する場合、sppDeviceDtoListにセットする
		if (json.has(SppDeviceInfoList)) {
			sppDeviceDtoList = new ArrayList<SppDeviceDto>();
			JSONArray sppDeviceInfoArray = json.getJSONArray(SppDeviceInfoList);
			for (int j = 0; j < sppDeviceInfoArray.length(); j++) {
				JSONObject sppDeviceJson = sppDeviceInfoArray.getJSONObject(j);
				SppDeviceDto sppDeviceDto = new SppDeviceDto();
				// SPP通信機器ID
				sppDeviceDto.sppDeviceId = getInt(sppDeviceJson, SppDeviceId);
				// SPP通信機器名
				sppDeviceDto.sppDeviceName = getString(sppDeviceJson, SppDeviceName);
				// SPP通信機器から取得対象の開始文字列
				sppDeviceDto.dataStartIndex = getInt(sppDeviceJson, DataStartIndex);
				// SPP通信機器から取得対象の終了文字列
				sppDeviceDto.dataEndIndex = getInt(sppDeviceJson, DataEndIndex);
				sppDeviceDtoList.add(sppDeviceDto);
			}
		}

		if (json.has(ContentList)) {
			JSONArray jarr = json.getJSONArray(ContentList);
			
			int count = jarr.length();
			contentVersions = new ArrayList<ContentDto>();
			
			for (int i = 0; i < count; i++) {
				JSONObject version = jarr.getJSONObject(i);
				long contentId = getLong(version, ContentId);
				int metaVersion = getInt(version, MetaVersion);
				int resourceVersion = getInt(version, ResourceVersion);
				String contentNameKana = getString(version, ContentNameKana, null);
				int contentType = getInt(version, ContentType, 0);
				
				contentVersions.add(new ContentDto(contentId, metaVersion, resourceVersion, contentNameKana, contentType));
			}
		} else {
			throw new JSONValidationException(json.toString(), ContentList + " property not found.");
		}
	}
}
