package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.DashboardStatusDto;

import static jp.agentec.abook.abv.bl.acms.client.json.OperationDataJSON.OperationId;
import static jp.agentec.abook.abv.bl.acms.client.json.OperationDataJSON.OperationList;
import static jp.agentec.abook.abv.bl.acms.client.json.OperationDataJSON.ReportList;
import static jp.agentec.abook.abv.bl.acms.client.json.OperationDataJSON.ReportStartDate;
import static jp.agentec.abook.abv.bl.acms.client.json.OperationDataJSON.ReportStatus;
import static jp.agentec.abook.abv.bl.acms.client.json.OperationDataJSON.TaskKey;
import static jp.agentec.abook.abv.bl.acms.client.json.OperationDataJSON.TaskReportId;
import static jp.agentec.abook.abv.bl.acms.client.json.OperationListJSON.OperationName;

public class DashboardStatusJSON extends AcmsCommonJSON {
    private static final String TAG = "DashboardStatusJSON";

    private List<DashboardStatusDto> reportStatuses;

    public DashboardStatusJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) {
        // 使わないので無視 → //presentTimeUTC = dateOrNull(json.getString("presentTimeUTC"));
        JSONArray oprations = json.getJSONArray(OperationList);

        String timeZone = TimeZone.getDefault().getID();
        reportStatuses = new ArrayList<DashboardStatusDto>();

        for (int i = 0; i < oprations.length(); i++) {
            JSONObject opJson = oprations.getJSONObject(i);
            try {
                long operationId = getLongOrZero(opJson, OperationId);
                String operationName = getStringOrNull(opJson, OperationName);
                JSONArray reports = opJson.getJSONArray(ReportList);
                for (int j = 0; j < reports.length(); j++) {
                    JSONObject repJson = reports.getJSONObject(j);
                    String taskKey = getStringOrNull(repJson, TaskKey);
                    Long taskReportId = getLongOrNull(repJson, TaskReportId);
                    Date reportStartDate = getDateOrNull(repJson, ReportStartDate, timeZone);
                    int reportStatus = getIntOrZero(repJson,ReportStatus);
                    DashboardStatusDto rep = new DashboardStatusDto(
                            taskKey,
                            taskReportId,
                            reportStartDate,
                            operationId,
                            operationName,
                            reportStatus
                    );
                    reportStatuses.add(rep);
                }
            } catch (Throwable e) {
                Logger.e(TAG, e);
            }
        }
    }

    public List<DashboardStatusDto> getReportStatuses() {
        return reportStatuses;
    }
}
