package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONObject;

import java.util.Date;

import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;

/**
 * checkapi/lockReport/のレスポンスを変換するクラス
 */
public class LockReportJSON extends AcmsCommonJSON {

    public static final int BAD_STATE = 999;
    private Date presentTimeUTC;
    private int reportStatus;
    private String reportLockUserId;
    private String reportLockUserName;
    private Date reportLockTime;

    public LockReportJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException {
        super.parse(json);
        presentTimeUTC = getDateOrNull(json, "presentTimeUTC");
        reportStatus = getIntOrDef(json, "reportStatus", BAD_STATE);
        reportLockUserId = getStringOrNull(json, "reportLockUserId");
        reportLockUserName = getStringOrNull(json, "reportLockUserName");
        reportLockTime = getDateOrNull(json, "reportLockTime");
    }

    @SuppressWarnings("unused")
    int getHttpStatus() {
        return httpStatus;
    }

    @SuppressWarnings("unused")
    Date getPresentTime() {
        return presentTime;
    }

    @SuppressWarnings("unused")
    public Date getPresentTimeUTC() {
        return presentTimeUTC;
    }

    @SuppressWarnings("unused")
    public int getReportStatus() {
        return reportStatus;
    }

    @SuppressWarnings("unused")
    public String getReportLockUserId() {
        return reportLockUserId;
    }

    @SuppressWarnings("unused")
    public String getReportLockUserName() {
        return reportLockUserName;
    }

    @SuppressWarnings("unused")
    public Date getReportLockTime() {
        return reportLockTime;
    }
}
