package jp.agentec.abook.abv.bl.acms.client.json;

import java.util.HashMap;
import java.util.Map;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.common.log.Logger;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

/**
 * {@link AcmsClient#contentVersion} の戻り値です。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class MasterDataJSON extends AcmsCommonJSON {
	public static final String MasterData = "masterData";
	public static final String BelongGroup = "belongGroup";
	public static final String Staff = "staff";
	public static final String Selective = "selective";
	public static final String InspectCheck = "inspectCheck";
	public static final String InspectNumber = "inspectNumber";
	public static final String FetchDate = "fetchDate";

	public String fetchDate;  // 取得日時（Timestamp yyyy-MM-dd HH:mm:ssGMT）
    public Map<String, String> masterDataMap;  // JSONマスタ（JSONオブジェクト）

	public MasterDataJSON(String jsonString) throws AcmsException {
		super(jsonString);
	}
	
	@Override
	protected void parse(JSONObject json) throws JSONValidationException {
		// fechDateの値をデバイスに保持し、次回API呼び出し時のパラメータに設定する。
		if (json.has(FetchDate)) {
            fetchDate = json.getString(FetchDate);
        }

        // マスタデータを取得する。
		if (json.has(MasterData)) {
			masterDataMap = new HashMap<String, String>();
			JSONObject masterData = json.getJSONObject(MasterData);

			// belongGroupの報告対象マスタ（JSONオブジェクト）
			if (masterData.has(BelongGroup)) {
				JSONObject belognGroupJson = masterData.getJSONObject(BelongGroup);
				masterDataMap.put(BelongGroup, belognGroupJson.toString());
			}

			// staffの報告者マスタ（JSONオブジェクト）
			if (masterData.has(Staff)) {
				JSONObject staffJson = masterData.getJSONObject(Staff);
				masterDataMap.put(Staff, staffJson.toString());
			}

			// selectiveの選択型マスタ（JSONオブジェクト）
			if (masterData.has(Selective)) {
				JSONObject selectiveJson = masterData.getJSONObject(Selective);
				masterDataMap.put(Selective, selectiveJson.toString());
			}

			// inspectCheckの点検チェック型マスタ（JSONオブジェクト）
			if (masterData.has(InspectCheck)) {
				JSONObject inspectCheckJson = masterData.getJSONObject(InspectCheck);
				masterDataMap.put(InspectCheck, inspectCheckJson.toString());
			}

			// inspectNumberの点検数値型マスタ（JSONオブジェクト）
			if (masterData.has(InspectNumber)) {
				JSONObject inspectNumberJson = masterData.getJSONObject(InspectNumber);
				masterDataMap.put(InspectNumber, inspectNumberJson.toString());
			}
		} else {
			throw new JSONValidationException(json.toString(), MasterData + " property not found.");
		}
	}
}
