package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.dto.OperationDto;
import jp.agentec.abook.abv.bl.dto.PushMessageDto;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

public class PushMessageListJSON extends AcmsCommonJSON {
    private static final String PushMessageList = "pushMessageList";
    public List<PushMessageDto> pushMessageList;

    public static final String OperationId = "operationId";
    private static final String PushMessageId = "pushMessageId";
    private static final String PushSendDate = "pushSendDate";
    private static final String PushMessage = "pushMessage";
    private static final String ReadFlg = "readFlg";

    public PushMessageListJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }
    @Override
    protected void parse(JSONObject json) {
        pushMessageList = new ArrayList();
        if (json.has(PushMessageList)) {
            JSONArray pushMessageArray = json.getJSONArray(PushMessageList);
            for (int i = 0; i < pushMessageArray.length(); i++) {
                JSONObject pushMessageJson = pushMessageArray.getJSONObject(i);
                PushMessageDto pushMessageDto = new PushMessageDto();
                pushMessageDto.pushMessageId = pushMessageJson.getLong(PushMessageId);
                if (pushMessageJson.has(OperationId)) {
                    pushMessageDto.operationId = pushMessageJson.getLong(OperationId);
                } else {
                    pushMessageDto.operationId = Long.valueOf(0);
                }
                pushMessageDto.pushSendDate = DateTimeUtil.toDate(pushMessageJson.getString(PushSendDate), DateTimeFormat.yyyyMMddHHmmss_hyphen);
                pushMessageDto.pushMessage = pushMessageJson.getString(PushMessage);
                pushMessageDto.readingFlg = (pushMessageJson.getInt(ReadFlg) != 0);

                pushMessageList.add(pushMessageDto);
            }
        }
    }
}
