package jp.agentec.abook.abv.bl.acms.client.json;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;

import org.json.adf.JSONObject;

/**
 * {@link AcmsClient#serverTimeZone の戻り値です。
 * @version 1.0.0
 */
public class ServerTimeZoneJSON extends AcmsCommonJSON {
	private static final String TIME_ZONE = "timeZone";
	private static final String PRESENT_TIME_UTC = "presentTimeUTC";
	
	public String timeZone;
	public String presentTimeUTC;
	
	public ServerTimeZoneJSON(String jsonString) throws AcmsException {
		super(jsonString);
	}

	@Override
	protected void parse(JSONObject json) throws JSONValidationException {
		timeZone = getString(json, TIME_ZONE);
		presentTimeUTC = getString(json, PRESENT_TIME_UTC);
	}
}
