package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONObject;

import java.util.Date;

import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;

import static jp.agentec.abook.abv.bl.acms.client.json.OperationDataJSON.ReportStatus;


public class UnlockReportJSON extends AcmsCommonJSON {
    private Date presentTimeUTC;
    private int reportStatus;

    public UnlockReportJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException {
        super.parse(json);
        presentTimeUTC = getDateOrNull(json, PresentTimeUTC);
        reportStatus = getIntOrZero(json, ReportStatus);
    }

    @SuppressWarnings("unused")
    public int getHttpStatus() {
        return httpStatus;
    }

    @SuppressWarnings("unused")
    public Date getPresentTime() {
        return presentTime;
    }

    @SuppressWarnings("unused")
    public Date getPresentTimeUTC() {
        return presentTimeUTC;
    }

    @SuppressWarnings("unused")
    public int getReportStatus() {return reportStatus; }
}
