package jp.agentec.abook.abv.bl.acms.client.json.content;

import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.common.util.JsonUtil;
import jp.agentec.adf.util.StringUtil;

import org.json.adf.JSONArray;
import org.json.adf.JSONException;
import org.json.adf.JSONObject;

public class ContentJSON extends AbstractJSON {
	private static final String TAG = "ContentJSON";
	
	private enum Rotation {
		VERTICAL,
		HORIZONTAL
	}
	/**
	 * JSON Param
	 */
	public static final String KEY_CONTENT_TYPE = "contentType";
	public static final String KEY_PDF_TYPE = "pdf";
	public static final String KEY_IMAGE_TYPE = "image";
	public static final String KEY_MOVIE_TYPE = "movie";
	public static final String KEY_MUSIC_TYPE = "music";
	public static final String KEY_HTML_TYPE = "html";
	public static final String KEY_OTHER_TYPE = "other";
	public static final String KEY_NONE_TYPE = "none";
	public static final String KEY_LINK_TYPE = "url";
	public static final String KEY_ENQUETE_TYPE = "enquete";
	public static final String KEY_EXAM_TYPE = "exam";
	public static final String KEY_PANO_MOVIE_TYPE = "panoMovie";
	public static final String KEY_PANO_IMAGE_TYPE = "panoImage";
	public static final String KEY_OBJECTVR_TYPE = "objectvr";

	public static final String KEY_HORIZONTAL = "horizontal";
	public static final String KEY_VERTICAL = "vertical";
	public static final String KEY_CONTENT = "content";
	public static final String KEY_ORIENTATION = "orientation";
	
	public static final String KEY_FILE_NAME = "fileName";
	public static final String KEY_URL = "url";
	public static final String KEY_PDF_FILE = "pdfFile";
	public static final String KEY_PAGES = "pages";
	
	public static final String KEY_TOTAL_PAGE_NUM = "totalPageNum";
	public static final String KEY_PAGE = "page";
	public static final String KEY_OBJECTS = "objects";

	public static final String KEY_HEIGHT = "height";
	public static final String KEY_WIDTH = "width";
	public static final String KEY_BACKGROUND_COLOR = "backgroundColor";
	public static final String KEY_BACKGROUND_ALPHA = "backgroundAlpha";
	
	private JSONArray mPages;
	
	private Rotation mRotation;
	private String mPdfFileName;
	private String contentType;
	private String fileName;
	private int width;
	private int height;
	private String backgroundColor;
	private int backgroundAlpha;
	private int totalPageNum;
	
	public ContentJSON(String json) {
		super(json);
		
		JSONObject content = JsonUtil.getJSONObject(root, KEY_VERTICAL);
		if (content == null) {
			content = JsonUtil.getJSONObject(root, KEY_HORIZONTAL);
			if (content == null) {
				content = root.getJSONObject(KEY_CONTENT); // これでnullの場合例外スロー
				String orientation = JsonUtil.getString(root, KEY_ORIENTATION);
				if (orientation != null && orientation.equals("vertical")) {
					mRotation = Rotation.VERTICAL;
				}
				else {
					mRotation = Rotation.HORIZONTAL;
				}
			}
			mRotation = Rotation.HORIZONTAL;
			Logger.d(TAG, Rotation.HORIZONTAL.name());
		} else {
			mRotation = Rotation.VERTICAL;
			Logger.d(TAG, Rotation.VERTICAL.name());
		}

        mPdfFileName = JsonUtil.getString(content, KEY_PDF_FILE);
        mPages = JsonUtil.getJSONArray(content, KEY_PAGES);
		
		contentType = JsonUtil.getString(root, KEY_CONTENT_TYPE);
		if (contentType == null) {
			contentType = KEY_PDF_TYPE;
		}
		
		fileName = JsonUtil.getString(content, KEY_FILE_NAME);
		if (contentType.equals(KEY_PDF_TYPE)) {
			if (StringUtil.isNullOrEmpty(mPdfFileName)) {
                mPdfFileName = fileName;
			}
			if (StringUtil.isNullOrEmpty(mPdfFileName)) {
				throw new JSONException("pdfFileName and fileName is null.");
			}
		}
		else if(contentType.equals(KEY_LINK_TYPE)){
			fileName = JsonUtil.getString(content, KEY_URL);
			if (StringUtil.isNullOrEmpty(fileName)) {
				throw new JSONException("fileName is null.");
			}
		}
		else if (!contentType.equals(KEY_NONE_TYPE)) {
			if (StringUtil.isNullOrEmpty(fileName)) {
				throw new JSONException("fileName is null.");
			}
		}
		
		if (contentType.equals(KEY_NONE_TYPE)) {
			width = root.getInt(KEY_WIDTH);
			height = root.getInt(KEY_HEIGHT);
			backgroundColor = JsonUtil.getString(root, KEY_BACKGROUND_COLOR); // nullの場合デフォルト値
			Float alpha = JsonUtil.getFloat(root, KEY_BACKGROUND_ALPHA);
			if (alpha == null) {
				alpha = 1.0f;
			}
			backgroundAlpha = (int) (alpha * 255);
			totalPageNum = root.getInt(KEY_TOTAL_PAGE_NUM);
		}
	}

//	TODO: 未使用（削除用確認）
//	public String getContentId() {
//		return JsonUtil.getString(root, KEY_CONTENT_ID);
//	}
	
	public String getPdfFileName() {
		return mPdfFileName;
	}
	
	public String getContentType() {
		return contentType;
	}
	
	public String getFileName() {
		return fileName;
	}
	
	public int getWidth() {
		return width;
	}

	public int getHeight() {
		return height;
	}

	public String getBackgroundColor() {
		return backgroundColor;
	}

	public int getBackgroundAlpha() {
		return backgroundAlpha;
	}

	public boolean isPdf() {
		return !StringUtil.isNullOrEmpty(mPdfFileName);
	}
	
	public int getPageCount() {
		return (mPages==null)? 1: mPages.length();
	}
	
	/**
	 * Page毎の設定Object情報を取り出す
	 * @param pageNumber
	 * @return JSONArray pageがない場合nullが返る
	 */
	public JSONArray getPageObject(int pageNumber) {
		JSONArray result = null;
		try {
			for (int i = 0; i < mPages.length(); i++) {
				JSONObject temp = mPages.getJSONObject(i);
				int page = JsonUtil.getInt(temp, KEY_PAGE);
				if (page == pageNumber) {
					result = JsonUtil.getJSONArray(temp, KEY_OBJECTS);
					break;
				}
			}
		} catch (JSONException e) {
			//
		}
		return result;
	}
	
	public int getTotalPageNum() {
		return totalPageNum;
	}
	
	//////////////
}
