package jp.agentec.abook.abv.bl.acms.client.parameters;

import java.util.Date;

import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

/**
 * checkapi/lockReport/のリクエストに使うパラメータ
 */
public class LockReportParameters extends AcmsParameters {

    private String sid;
    private String taskKey;
    private Long taskReportId;
    private String reportStartDate;     // 書式の問題があるので、あえて文字列
    private String userId;
    private String userName;

    public LockReportParameters(
            String sid,
            String taskKey,
            Long taskReportId,
            Date reportStartDate,
            String userId,
            String userName
    ) {
        super(sid);
        this.sid = sid;
        this.taskKey = taskKey;
        this.taskReportId = taskReportId;
        this.reportStartDate = DateTimeUtil.toStringInTimeZone(reportStartDate, DateTimeFormat.yyyyMMddHHmmss_hyphen, "UTC");
        this.userId = userId;
        this.userName = userName;
    }

    public String getTaskKey() {
        return taskKey;
    }

    public Long getTaskReportId() {
        return taskReportId;
    }

    public String getReportStartDate() {
        return reportStartDate;
    }

    public String getUserId() {
        return userId;
    }

    public String getUserName() {
        return userName;
    }
}
