package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.abook.abv.bl.common.util.SecurityUtil;
import jp.agentec.adf.net.http.HttpParameterObject;

/**
 * ユーザ認証用パラメータです。
 * @author Taejin Hong
 * @version 1.0.0
 */
@Deprecated
public class MobileLoginParameters extends HttpParameterObject {
	/**
	 * ユーザのログインIDです。
	 * @since 1.0.0
	 */
	private String loginId;
	/**
	 * ユーザのパスワードです。
	 * @since 1.0.0
	 */
	private String password;
	/**
	 * 端末の一意IDです。
	 * @since 1.0.0
	 */
	private String udid;
	/**
	 * 端末タイプです。
	 * @since 1.0.0
	 */
	private int deviceTypeId;
	/**
	 * {@link MobileLoginParameters} クラスのインスタンスを初期化します。
	 * @param loginId ユーザのログインIDです。半角英数字と'_'、'-'のみ使えます。
	 * @param memberPassword ユーザのパスワードです。半角英数字と'_'、'-'のみ使えます。
	 * @param udid 端末の一意IDです。半角英数字と'_'、'-'のみ使えます。
	 * @param deviceTypeId 端末タイプです。
	 * @throws IllegalArgumentException 引数のどれかが半角英数字と'_'、'-'ではありません。
	 * @since 1.0.0
	 */
	public MobileLoginParameters(String loginId, String memberPassword, String udid, int deviceTypeId) throws IllegalArgumentException {
		SecurityUtil.validateLoginInformation(loginId, memberPassword, udid);
		
		this.loginId = loginId;
		this.password = memberPassword;
		this.udid = udid;
		this.deviceTypeId = deviceTypeId;
	}

	/**
	 *  ユーザのログインIDを指定します。
	 * @return ユーザのログインIDです。
	 * @since 1.0.0
	 */
	public String getLoginId() {
		return loginId;
	}
	/**
	 * ユーザのパスワードを取得します。
	 * @return ユーザのパスワードです。
	 * @since 1.0.0
	 */
	public String getPassword() {
		return password;
	}
	/**
	 * 端末の一意IDを取得します。
	 * @return 端末の一意IDです。
	 * @since 1.0.0
	 */
	public String getUdid() {
		return udid;
	}
	/**
	 * 端末タイプを返します。
	 * @return 端末タイプです。
	 * @since 1.0.0
	 */
	public int getDeviceTypeId() {
		return deviceTypeId;
	}
}
