package jp.agentec.abook.abv.bl.acms.client.parameters;

import java.util.Date;

import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

/**
 * checkapi/unlockReport/のリクエストに使うパラメータ
 */
public class UnlockReportParameters extends AcmsParameters {

    private String taskKey;
    private Long taskReportId;
    private String reportStartDate;     // 書式の問題があるので、あえて文字列

    public UnlockReportParameters(
            String sid,
            String taskKey,
            Long taskReportId,
            Date reportStartDate
    ) {
        super(sid);

        this.taskKey = taskKey;
        this.taskReportId = taskReportId;
        this.reportStartDate = DateTimeUtil.toStringInTimeZone(reportStartDate, DateTimeFormat.yyyyMMddHHmmss_hyphen, "UTC");
    }

    public String getTaskKey() {
        return taskKey;
    }

    public Long getTaskReportId() {
        return taskReportId;
    }

    public String getReportStartDate() {
        return reportStartDate;
    }
}
