package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.MemberInfoDto;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

public class MemberInfoDao extends AbstractDao {

	/**
	 * {@link MemberInfoDao} のインスタンスを初期化します。
	 * アンドロイドの android.content.Context のインスタンス
	 * @throws ClassCastException 引数のcontextが android.content.Context 又は、その継承クラスではありません。
	 * @since 1.0.0
	 */
	/*package*/ MemberInfoDao() {
	}

	@Override
	protected MemberInfoDto convert(Cursor cursor) {
		MemberInfoDto dto = new MemberInfoDto();

		int column = cursor.getColumnIndex("login_id");
		if (column != -1) {
			dto.loginId = cursor.getString(column);
		}
		column = cursor.getColumnIndex("password");
		if (column != -1) {
			dto.password = cursor.getString(column);
		}
		column = cursor.getColumnIndex("member_name");
		if (column != -1) {
			dto.memberName = cursor.getString(column);
		}
		column = cursor.getColumnIndex("sid");
		if (column != -1) {
			dto.sid = cursor.getString(column);
		}
		column = cursor.getColumnIndex("login_status");
		if (column != -1) {
			dto.loginStatus = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("invalid_password_count");
		if (column != -1) {
			dto.invalidPasswordCount = cursor.getShort(column);
		}
		column = cursor.getColumnIndex("last_login_date");
		if (column != -1) {
			dto.lastLoginDate = DateTimeUtil.toDate(cursor.getString(column), "UTC", DateTimeFormat.yyyyMMddHHmmss_hyphen);
		}
		column = cursor.getColumnIndex("last_cms_access_date");
		if (column != -1) {
			dto.lastCMSAccessDate = DateTimeUtil.toDate(cursor.getString(column), "UTC", DateTimeFormat.yyyyMMddHHmmss_hyphen);
		}
		column = cursor.getColumnIndex("last_change_password_date");
		if (column != -1) {
			dto.lastChangePasswordDate = DateTimeUtil.toDate(cursor.getString(column), "UTC", DateTimeFormat.yyyyMMddHHmmss_hyphen);
		}
		column = cursor.getColumnIndex("password_expiry_date");
		if (column != -1) {
			dto.passwordExpiryDate = DateTimeUtil.toDate(cursor.getString(column), "UTC", DateTimeFormat.yyyyMMddHHmmss_hyphen);
		}

		column = cursor.getColumnIndex("user_id");
		if (column != -1) {
			dto.userId = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("last_update_infor");
		if (column != -1) {
			dto.lastUpdateInfor = cursor.getString(column);
		}
		column = cursor.getColumnIndex("worker_code");
		if (column != -1) {
			dto.workerCode = cursor.getString(column);
		}

		return dto;
	}

	public MemberInfoDto getMemberInfo() {
		List<MemberInfoDto> list = rawQueryGetDtoList("select * from m_member_info", null, MemberInfoDto.class);
		MemberInfoDto memberInfoDto = null;

		if (list != null && list.size() > 0) {
			memberInfoDto = list.get(0);
		}

		return memberInfoDto;
	}

	public MemberInfoDto getMemberInfo(int loginStatus) {
		return rawQueryGetDto("select * from m_member_info where login_status=?", new String[]{""+ loginStatus}, MemberInfoDto.class);
	}

	public String getLastUpdateInfor() {
		return rawQueryGetString("select last_update_infor from m_member_info",null);
	}

	public void updateLastUpdateInfor(String lastUpdateInfor) {
		update("update m_member_info set last_update_infor = ?", new String[]{lastUpdateInfor});
	}

	public void insertMemberInfo(MemberInfoDto dto) {
		insert("insert into m_member_info (login_id, password, member_name, sid, login_status, invalid_password_count, last_login_date, last_change_password_date, last_cms_access_date, user_id, last_update_infor, worker_code) values (?,?,?,?,?,?,?,?,?,?,?,?)", dto.getInsertValues());
	}

	public boolean updateMemberInfo(MemberInfoDto dto) {
		long count = update("update m_member_info set password=?, member_name=?, sid=?, login_status=?, invalid_password_count=?, last_login_date=?, last_change_password_date=?, last_cms_access_date=?, last_update_infor = ?, worker_code = ? where login_id=?", dto.getUpdateValues());
		return count > 0;
	}

	public void deleteMemberInfo() {
		try {
			beginTransaction();

			delete("l_content_page_reading_log", null, null);
			delete("l_content_object_log", null, null);
			delete("l_content_reading_log", null, null);
			delete("t_content_download_queue", null, null);
			delete("m_service_option", null, null);
			delete("m_member_info", null, null);

			commit();
		} catch (Exception e) {
			rollback();
			Logger.e("deleteMemberInfo failed.", e);
			throw new RuntimeException(e);
		} finally {
		}
	}


	public void deleteMemberContentInfo(boolean isAllDelete) {
		try {
			beginTransaction();

			delete("t_content_bookmark", null, null);
			delete("t_content_memo", null, null);

			update("update t_content set favorite_flg=0", null);
			if (isAllDelete) {
				delete("r_content_group", null, null);
			} else {
				delete("r_content_group", "group_relation_id not in (select group_relation_id from m_group where group_level = 0)", null);
			}
			commit();
		} catch (Exception e) {
			rollback();
			Logger.e("deleteMemberContentInfo failed.", e);
			throw new RuntimeException(e);
		} finally {
		}
	}

	public void deleteMemberMydataInfo() {
		try {
			beginTransaction();

			delete("t_content_bookmark", null, null);
			delete("t_content_memo", null, null);
			update("update t_content set reading_date = null, reading_count = 0", null);

			commit();
		} catch (Exception e) {
			rollback();
			Logger.e("deleteMemberContentInfo failed.", e);
			throw new RuntimeException(e);
		} finally {
		}
	}
}
