package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.dto.TaskDto;

/**
 * Created by leej on 2018/08/31.
 */

public class TaskDao extends AbstractDao {

    private static final String TAG = "TaskDao";

    /*package*/ TaskDao() {
    }

    @Override
    protected TaskDto convert(Cursor cursor) {
        TaskDto dto = new TaskDto();

        int column = cursor.getColumnIndex("task_key");
        if (column != -1) {
            dto.taskKey = cursor.getString(column);
        }
        column = cursor.getColumnIndex("task_id");
        if (column != -1) {
            dto.taskId = cursor.getLong(column);
        }
        column = cursor.getColumnIndex("operation_id");
        if (column != -1) {
            dto.operationId = cursor.getLong(column);
        }
        column = cursor.getColumnIndex("task_code");
        if (column != -1) {
            dto.taskCode = cursor.getString(column);
        }
        column = cursor.getColumnIndex("task_status");
        if (column != -1) {
            dto.taskStatus = cursor.getInt(column);
        }
        column = cursor.getColumnIndex("task_hotspot_info");
        if (column != -1) {
            dto.taskHotSpotInfo = cursor.getString(column);
        }
        column = cursor.getColumnIndex("del_flg");
        if (column != -1) {
            dto.delFlg = toBool(cursor.getInt(column));
        }
        column = cursor.getColumnIndex("task_has_Authority");
        if (column != -1) {
            dto.taskHasAuthority = toBool(cursor.getInt(column));
        }

        return dto;
    }

    public List<TaskDto> selectTaskByOperationId(Long operationId) {
        return rawQueryGetDtoList("select * from t_task where operation_id = ? and del_flg = 0 ", new String[]{"" + operationId}, TaskDto.class);
    }

    public List<TaskDto> selectAllTaskByOperationId(Long operationId) {
        return rawQueryGetDtoList("select * from t_task where operation_id = ? ", new String[]{"" + operationId}, TaskDto.class);
    }

    public TaskDto getTaskByTaskKey(String taskKey) {
        return rawQueryGetDto("select * from t_task where task_key=?", new String[]{"" + taskKey}, TaskDto.class);
    }

    public void insert(TaskDto dto) {
        insert("insert into t_task "
                        + "(task_key, "
                        + "task_id, "
                        + "operation_id, "
                        + "task_code, "
                        + "task_status, "
                        + "task_hotspot_info) "
                        + "values "
                        + "(?,?,?,?,?,?)",
                dto.getInsertValues());
    }

    public boolean update(TaskDto dto) {
        long count = update("update t_task "
                        + "set "
                        + "task_id=?, "
                        + "operation_id=?, "
                        + "task_code=?, "
                        + "task_status=?, "
                        + "task_hotspot_info=?, "
                        + "del_flg=? "
                        + "where task_key=?",
                dto.getUpdateValues());
        return count > 0;
    }

    /**
     * 作業削除
     * @param taskKey
     */
    public void deleteTaskData(String taskKey) {
        String[] keyValues = new String[]{""+ taskKey};
        delete("t_task", "task_key=?", keyValues);
        delete("t_task_report", "task_key=?", keyValues);
        delete("t_task_report_items", "task_key=?", keyValues);
        delete("t_task_report_send", "task_key=?", keyValues);
    }

    /**
     * 作業削除
     * @param dto
     */
    public void delete(TaskDto dto) {
        delete("t_task", "task_key=?", dto.getKeyValues());
        delete("t_task_report", "task_key=?", dto.getKeyValues());
        delete("t_task_report_items", "task_key=?", dto.getKeyValues());
        delete("t_task_report_send", "task_key=?", dto.getKeyValues());
    }
}