package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.data.DatabaseVersions;
import jp.agentec.adf.util.StringUtil;



/**
 * グループのマスターテーブルです。
 * @author Taejin Hong
 * @version 1.1.1
 */
public class MGroup extends SQLiteTableScript {
	
	public MGroup() {
		super();
	}
	
	@Override
	public List<String> getCreateScript(int version) {
		List<String> ddl = new ArrayList<String>();
		StringBuffer sql = new StringBuffer();
		
		//	since DatabaseVersions.Ver1_0_0
		sql.append(" CREATE TABLE m_group ( ");
		sql.append("        group_relation_id INTEGER NOT NULL  ");
		sql.append("      , group_id INTEGER NOT NULL ");
		sql.append("      , parent_group_id INTEGER NOT NULL ");
		sql.append("      , group_level INTEGER NOT NULL ");
		sql.append("      , group_name VARCHAR(64) NOT NULL ");
		sql.append("      , group_path TEXT NOT NULL ");	//	path enumaerationパターンを適用する。since DatabaseVersions.Ver1_5_0
		sql.append("      , user_group_flg BOOLEAN NOT NULL DEFAULT 0 ");	//	since DatabaseVersions.Plus_1_1_0
		sql.append("      , group_code VARCHAR(10) DEFAULT '' NOT NULL ");
		sql.append("      , PRIMARY KEY (group_relation_id) ");
		sql.append(" ) ");
		
		ddl.add(sql.toString());
		StringUtil.clear(sql);

		sql.append(" CREATE INDEX idx_group_1 ON m_group ( ");
		sql.append("        parent_group_id ");
		sql.append(" )  ");
		
		ddl.add(sql.toString());
		StringUtil.clear(sql);
		
//		sql.append(" CREATE UNIQUE INDEX udx_group_1 ON m_group ( "); // TODO:　これは複数の親を持てる場合には必要だが。
//		sql.append("        group_id, parent_group_id, group_level ");
//		sql.append(" ) ");
//
//		ddl.add(sql.toString());
//		StringUtil.clear(sql);
		
		//	since DatabaseVersions.Ver1_5_0
		sql.append(" CREATE UNIQUE INDEX udx_group_2 ON m_group ( ");
		sql.append("        group_path ");
		sql.append(" ) ");	
		
		ddl.add(sql.toString());
		
		return ddl;
	}

	@Override
	public List<String> getUpgradeScript(int oldVersion, int newVersion) {
		List<String> ddl = new ArrayList<String>();
		if (oldVersion < DatabaseVersions.Ver1_0_612) {
			ddl.add(" ALTER TABLE m_group ADD COLUMN group_code VARCHAR(10) DEFAULT '' NOT NULL ");
		}
		return ddl;
	}

	@Override
	public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object... params) {
		return null;
	}

}
