package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.data.DatabaseVersions;

/**
 * Created by kim jinsung on 2018/09/17.
 */

public class TPushMessage extends SQLiteTableScript {
    public TPushMessage() {
        super();
    }
    @Override
    public List<String> getCreateScript(int version) {
        List<String> ddl = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();

        sql.append(" CREATE TABLE t_push_message ( ");
        sql.append("        push_message_id BIGINT NOT NULL ");
        sql.append("      , operation_id BIGINT NOT NULL ");
        sql.append("      , push_send_date DATE NOT NULL ");
        sql.append("      , push_message TEXT ");
        sql.append("      , reading_flg BOOLEAN NOT NULL DEFAULT 0 ");
        sql.append("      , PRIMARY KEY (push_message_id) ");
        sql.append(" ) ");
        ddl.add(sql.toString());

        return ddl;
    }

    /**
     * Ver.1.0.600でプッシュメッセージ仕様変更によって
     * 制約削除が必要ですが、できないため、テーブル再作成
     * @return テーブル作成SQL
     */
    private String getCreatePushMessageTable() {
        StringBuffer sql = new StringBuffer();
        sql.append(" CREATE TABLE t_push_message_temp ( ");
        sql.append("        push_message_id BIGINT NOT NULL ");
        sql.append("      , operation_id BIGINT NOT NULL ");
        sql.append("      , push_send_date DATE NOT NULL ");
        sql.append("      , push_message TEXT ");
        sql.append("      , reading_flg BOOLEAN NOT NULL DEFAULT 0 ");
        sql.append("      , PRIMARY KEY (push_message_id) ");
        sql.append(" ) ");
        return sql.toString();
    }
    @Override
    public List<String> getUpgradeScript(int oldVersion, int newVersion) {
        List<String> ddl = new ArrayList<String>();
        if (oldVersion < DatabaseVersions.Ver1_0_5) {
            ddl.add(getCreatePushMessageTable());
            ddl.add(" INSERT INTO t_push_message_temp (push_message_id, operation_id, push_send_date, push_message, reading_flg)　SELECT push_message_id, operation_id, push_send_date, push_message, reading_flg FROM t_push_message ");
            ddl.add(" DROP TABLE t_push_message ");
            ddl.add(" ALTER TABLE t_push_message_temp RENAME TO t_push_message ");
        }

        return ddl;

    }

    @Override
    public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object[] params) {
        return null;
    }
}
