package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.data.DatabaseVersions;

/**
 * CMS側から取得したSPP通信端末を管理するテーブル
 */

public class TSppDevice extends SQLiteTableScript {

    public TSppDevice() {
        super();
    }

    @Override
    public List<String> getCreateScript(int version) {
        List<String> ddl = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();

        sql.append(" CREATE TABLE t_spp_device ( ");
        sql.append("        spp_device_id INTEGER NOT NULL");
        sql.append("      , spp_device_name VARCHAR(256) NOT NULL");
        sql.append("      , data_start_index INTEGER NOT NULL ");
        sql.append("      , data_end_index INTEGER NOT NULL ");
        sql.append("      , pairing_device_name VARCHAR(256) ");
        sql.append("      , pairing_device_address VARCHAR(256) ");
        sql.append("      , PRIMARY KEY (spp_device_id) ");
        sql.append(" ) ");
        ddl.add(sql.toString());
        return ddl;
    }


    /**
     * マイグレーション処理
     * @param oldVersion
     * @param newVersion
     * @return
     */
    @Override
    public List<String> getUpgradeScript(int oldVersion, int newVersion) {
        List<String> ddl = new ArrayList<String>();
        if (oldVersion < DatabaseVersions.Ver1_0_2) {
            ddl.addAll(getCreateScript(newVersion));
        }
        return ddl;
    }

    @Override
    public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object[] params) {
        return null;
    }
}
