package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.data.DatabaseVersions;

/**
 * Created by leej on 2018/08/31.
 */

public class TTaskReport extends SQLiteTableScript {

    public TTaskReport() {
        super();
    }

    @Override
    public List<String> getCreateScript(int version) {
        List<String> ddl = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();

        sql.append(" CREATE TABLE t_task_report ( ");
        sql.append("        task_key TEXT NOT NULL ");
        sql.append("      , json_data TEXT NOT NULL");
        sql.append("      , attached_file_name TEXT ");
        sql.append("      , local_attached_file_name TEXT ");
        sql.append("      , attached_file_send_flg BOOLEAN DEFAULT 0 ");
        sql.append("      , data_send_flg BOOLEAN DEFAULT 0 ");
        sql.append("      , report_start_date DATETIME ");
        sql.append("      , report_end_date DATETIME ");
        sql.append("      , task_report_id INTEGER NOT NULL DEFAULT 0 ");
        sql.append("      , task_report_info_id INTEGER NOT NULL DEFAULT 0 ");
        sql.append("      , enable_report SMALLINT NOT NULL DEFAULT 0 ");
        sql.append("      , task_report_level SMALLINT NOT NULL DEFAULT 0 ");
        sql.append("      , local_saved_flg BOOLEAN DEFAULT 0 ");
        sql.append("      , report_lock_user_id TEXT ");       // 報告ロックユーザId
        sql.append("      , report_lock_user_name TEXT ");	    //報告ロックユーザ名
        sql.append("      , report_lock_time DATETIME ");     // 報告ロック日時
        sql.append("      , send_back_user_id TEXT ");	        // 差し戻しユーザId	差し戻された場合のみ" +
        sql.append("      , send_back_user_name TEXT ");	    // 差し戻しユーザ名	差し戻された場合のみ
        sql.append("      , send_back_comment TEXT ");        // 確認コメント	差し戻された場合のみ
        sql.append("      , report_status INTEGER NOT NULL DEFAULT 0 ");   // 0:ロック成功、1:ロック中、2:承認中、999:その他エラー
        sql.append("      , task_status INTEGER  NOT NULL DEFAULT 0 ");             // 状況	0：未実施、1：作業中、999：作業完了
        sql.append(" ) ");
        ddl.add(sql.toString());

        ddl.add("CREATE INDEX idx_task_key1 ON t_task_report(task_key, task_report_id, report_start_date)");

        return ddl;
    }


    @Override
    public List<String> getUpgradeScript(int oldVersion, int newVersion) {
        List<String> ddl = new ArrayList<String>();
        if (oldVersion < DatabaseVersions.Ver1_0_4) {
            ddl.add(" ALTER TABLE t_task_report ADD COLUMN report_lock_user_id	TEXT");	    // 報告ロックユーザId
            ddl.add(" ALTER TABLE t_task_report ADD COLUMN report_lock_user_name TEXT");	//報告ロックユーザ名
            ddl.add(" ALTER TABLE t_task_report ADD COLUMN report_lock_time DATETIME");     // 報告ロック日時
            ddl.add(" ALTER TABLE t_task_report ADD COLUMN send_back_user_id TEXT");	    // 差し戻しユーザId	差し戻された場合のみ" +
            ddl.add(" ALTER TABLE t_task_report ADD COLUMN send_back_user_name TEXT");      // 差し戻しユーザ名	差し戻された場合のみ
            ddl.add(" ALTER TABLE t_task_report ADD COLUMN send_back_comment TEXT");	    // 確認コメント	差し戻された場合のみ
            ddl.add(" ALTER TABLE t_task_report ADD COLUMN task_status INTEGER NOT NULL DEFAULT 0");	            // 状況	0：未実施、1：作業中、999：作業完了
            ddl.add(" ALTER TABLE t_task_report ADD COLUMN report_status INTEGER NOT NULL DEFAULT 0");   // 0:ロック成功、1:ロック中、2:承認中、999:その他エラー
            ddl.add("CREATE INDEX idx_task_key1 on t_task_report(task_key, task_id, report_start_date)");
            ddl.add("CREATE INDEX idx_task_key2 on t_task_report_status(task_key, task_id, report_start_date)");
        }

        return ddl;
    }

    @Override
    public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object[] params) {
        return null;
    }
}
