package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;

import static jp.agentec.abook.abv.bl.data.DatabaseVersions.Ver1_0_4;

public class TTaskReportStatus extends SQLiteTableScript {

    public static final String tableName = "t_task_report_status";

    @Override
    public List<String> getCreateScript(int version) {
        List<String> ddl = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();

        sql.append("CREATE TABLE " + tableName +" ( ");
        sql.append("    task_key            TEXT NOT NULL DEFAULT '',");
        sql.append("    task_code           TEXT NOT NULL DEFAULT '',");
        sql.append("    task_report_id      INTEGER,");
        sql.append("    report_start_date   DATETIME,");
        sql.append("    operation_id        BIGINT NOT NULL DEFAULT 0,");
        sql.append("    operation_name      TEXT NOT NULL DEFAULT '',");
        sql.append("    report_status       INTEGER NOT NULL DEFAULT 0,");
        sql.append("    untouched_flg       INTEGER NOT NULL DEFAULT 0,");  // 未実施（0x01）
        sql.append("    working_flg         INTEGER NOT NULL DEFAULT 0,");  // 作業中（0x02)
        sql.append("    complete_ok_flg     INTEGER NOT NULL DEFAULT 0,");  // 作業完了 異常なし(0x04)
        sql.append("    complete_ng_flg     INTEGER NOT NULL DEFAULT 0,");  // 作業完了 異常あり(0x08)
        sql.append("    incomplete_flg      INTEGER NOT NULL DEFAULT 0,");  // 期限切れ(0x10)
        sql.append("    alert_flg           INTEGER NOT NULL DEFAULT 0,");  // アラート(0x20)
        sql.append("    send_backed_flg     INTEGER NOT NULL DEFAULT 0)");  // 差し戻し(0x40)

        ddl.add(sql.toString());

        ddl.add("CREATE INDEX idx_task_key2 ON t_task_report_status(task_key, task_report_id, report_start_date)");

        return ddl;
    }

    @Override
    public List<String> getUpgradeScript(int oldVersion, int newVersion) {
        if (oldVersion < Ver1_0_4) {
            return getCreateScript(newVersion);
        } else {
            return null;
        }
    }

    @Override
    public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object[] params) {
        return null;
    }
}
