package jp.agentec.abook.abv.bl.dto;

import java.util.Date;

import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

public class DashboardStatusDto extends AbstractDto {

    private static final int FLG_UNTOUCHED = 0x01;      // 未実施（0x01）
    private static final int FLG_WORKING = 0x02;        // 作業中（0x02)
    private static final int FLG_COMPLETE_OK = 0x04;    // 作業完了 異常なし(0x04)
    private static final int FLG_COMPLETE_NG = 0x08;    // 作業完了 異常あり(0x08)
    private static final int FLD_INCOMPLETED = 0x10;    // 期限切れ(0x10)
    private static final int FLG_ALERT = 0x20;          // アラート(0x20)
    private static final int FLG_SEND_BACK = 0x40;      // 差し戻し(0x40)

    public static int UNTOUCHED = 0;    // 0:未実施
    public static int WORKING = 1;      // 1:作業中
    public static int COMPLETE_OK = 2;  // 2:作業完了(異常なし)
    public static int COMPLETE_NG = 3;  // 3:作業完了(異常あり)
    public static int INCOMPLETED = 4;  // 4:期限切れ
    public static int ALERT = 5;        // 5:アラート
    public static int SEND_BACKED = 6;  // 6:差し戻し
    public static int IN_PROGRESS = 7;  // 7:一時保存

    // taskReportを一意にさすためのキー
    private String taskKey;
    private Long taskReportId;
    private Date reportStartDate;
    // 一覧表示で必要な付加情報
    private long operationId;
    private String operationName;
    // taskの状態を示すビットフィールド
    private int reportStatus;
    // reportStatusの各ビットに対応するフラグ
    private int untouchedFlg;
    private int workingFlg;
    private int completeOkFlg;
    private int completeNgFlg;
    private int incompleteFlg;
    private int alertFlg;
    private int sendBackedFlg;

    public DashboardStatusDto(
            String taskKey,
            Long taskReportId,
            Date reportStartDate,
            long operationId,
            String operatonName,
            int reportStatus
    ) {
        this.taskKey = taskKey;
        this.taskReportId = taskReportId;
        this.reportStartDate = reportStartDate;
        this.operationId = operationId;
        this.operationName = operatonName;
        this.reportStatus = reportStatus;

        untouchedFlg = reportStatus & FLG_UNTOUCHED;
        workingFlg = reportStatus & FLG_WORKING;
        completeOkFlg = reportStatus & FLG_COMPLETE_OK;
        completeNgFlg = reportStatus & FLG_COMPLETE_NG;
        incompleteFlg = reportStatus & FLD_INCOMPLETED;
        alertFlg = reportStatus & FLG_ALERT;
        sendBackedFlg = reportStatus & FLG_SEND_BACK;
    }

    @Override
    public String[] getKeyValues() {
        return new String[] {
                String.valueOf(taskKey),
                String.valueOf(taskReportId),
                DateTimeUtil.toString(reportStartDate, DateTimeFormat.yyyyMMdd_hyphen)
        };
    }

    @Override
    public Object[] getInsertValues() {
        return new Object[] {
                taskKey,
                taskReportId,
                reportStartDate,
                operationId,
                operationName,
                reportStatus,
                untouchedFlg,   // 未実施（0x01）
                workingFlg,     // 作業中（0x02)
                completeOkFlg,  // 作業完了 異常なし(0x04)
                completeNgFlg,  // 作業完了 異常あり(0x08)
                incompleteFlg,  // 期限切れ(0x10)
                alertFlg,       // アラート(0x20)
                sendBackedFlg   // 差し戻し(0x40)
        };
    }

    public String getTaskKey() {
        return taskKey;
    }

    public Long getTaskReportId() {
        return taskReportId;
    }

    public Date getReportStartDate() {
        return reportStartDate;
    }

    public int getReportStatus() {
        return reportStatus;
    }

    public long getOperationId() {
        return operationId;
    }

    public String getOperationName() {
        return operationName;
    }
}
