package jp.agentec.abook.abv.bl.dto;

import org.json.adf.JSONObject;

import java.util.Date;

import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

public class ReportStatusDto extends AbstractDto {

    public int reportStatus;
    public long operationId;
    public String operationName;
    public String taskKey;
    public String taskCode;
    public JSONObject taskReportInfo;
    public Long taskReportId;
    public Date reportStartDate;
    public String reportLockUserId;
    public String reportLockUserName;
    public Date reportLockTime;
    public String sendBackUserId;
    public String sendBackUserName;
    public String sendBackComment;

    @Override
    public String[] getKeyValues() {
        return new String[0];
    }

    @Override
    public Object[] getInsertValues() {
        return new Object[0];
    }


    public int getReportStatus() {
        return reportStatus;
    }

    public long getOperationId() {
        return operationId;
    }

    public String getOperationName() {
        return operationName;
    }

    public String getTaskKey() {
        return taskKey;
    }

    public String getTaskCode() {
        return taskCode;
    }

    public JSONObject getTaskReportInfo() {
        return taskReportInfo;
    }

    public Long getTaskReportId() {
        return taskReportId;
    }

    public Date getReportStartDate() {
        return reportStartDate;
    }

    public String getReportStartDateAsString() {
        return DateTimeUtil.toString(reportStartDate, DateTimeFormat.yyyyMMddHHmmss_hyphen);
    }

    public String getReportLockUserId() {
        return reportLockUserId;
    }

    public String getReportLockUserName() {
        return reportLockUserName;
    }

    public Date getReportLockTime() {
        return reportLockTime;
    }

    public String getReportLockTimeAsString() {
        return DateTimeUtil.toString(reportLockTime, DateTimeFormat.yyyyMMddHHmmss_hyphen);
    }

    public String getSendBackUserId() {
        return sendBackUserId;
    }

    public String getSendBackUserName() {
        return sendBackUserName;
    }

    public String getSendBackComment() {
        return sendBackComment;
    }
}
