package jp.agentec.abook.abv.bl.dto;

import java.util.Date;

/**
 * Created by leej on 2018/09/10.
 */

public class TaskReportDto extends AbstractDto {

    public String taskKey;
    public String jsonData;
    public String localAttachedFileName;
    public boolean attachedFileSendFlg;
    public boolean dataSendFlg;
    public String taskHotSpotInfo;
    public boolean delFlg;

    // 　作業報告詳細リスト
    public int taskReportLevel;  // 作業報告レベル
    public int taskReportId;  // 作業報告ID
    public int taskReportInfoId;  // 作業報告情報ID
    public Date reportStartDate;  // 作業開始日
    public Date reportEndDate;  // 作業終了日
    public int enableReport;  // 報告可能区分
    public String attachedFileName;
    public boolean localSavedFlg; // 一時保存用

    public String reportLockUserId;     // 報告ロックユーザId
    public String reportLockUserName;   // 報告ロックユーザ名
    public Date reportLockTime;         // 報告ロック日時
    public String sendBackUserId;       // 差し戻しユーザId	差し戻された場合のみ
    public String sendBackUserName;     // 差し戻しユーザ名	差し戻された場合のみ
    public String sendBackComment;      // 確認コメント	差し戻された場合のみ
    public int taskStatus;              // 状況	0：未実施、1：作業中、999：作業完了
    public int reportStatus;

    @Override
    public Object[] getInsertValues() {
        return new Object[] { taskKey, jsonData, attachedFileName, localAttachedFileName, attachedFileSendFlg, dataSendFlg, taskReportId, taskReportInfoId, reportStartDate, reportEndDate, enableReport, taskReportLevel, reportLockUserId, reportLockUserName, reportLockTime, sendBackUserId, sendBackUserName, sendBackComment, taskStatus, reportStatus, localSavedFlg};
    }

    @Override
    public Object[] getUpdateValues() {
        return new Object[] { jsonData, attachedFileName, localAttachedFileName, attachedFileSendFlg, dataSendFlg, reportEndDate, enableReport, taskReportLevel, localSavedFlg, taskKey, taskReportLevel , reportLockUserId, reportLockUserName, reportLockTime, sendBackUserId, sendBackUserName, sendBackComment, taskStatus, reportStatus, reportStartDate };
    }

    @Override
    public String[] getKeyValues() {
        return new String[] { "" + taskKey };
    }

    public LockInfo getLockInfo() {
        return new LockInfo(
                reportLockUserId,
                reportLockUserName,
                reportLockTime
        );
    }


    public static class LockInfo {
        public final String reportLockUserId;
        public final String reportLockUserName;
        public final Date reportLockTime;

        public LockInfo(
                String reportLockUserId,
                String reportLockUserName,
                Date reportLockTime
        ) {
            this.reportLockUserId = reportLockUserId;
            this.reportLockUserName = reportLockUserName;
            this.reportLockTime = reportLockTime == null ? null : new Date(reportLockTime.getTime());
        }
    }

    public SendBackInfo getSendBackInfo() {
        return new SendBackInfo(
                sendBackUserId,
                sendBackUserName,
                sendBackComment
        );
    }

    public static class SendBackInfo {
        public final String sendBackUserId;
        public final String sendBackUserName;
        public final String sendBackComment;

        public SendBackInfo(
                String sendBackUserId,
                String sendBackUserName,
                String sendBackComment
        ) {
            this.sendBackUserId = sendBackUserId;
            this.sendBackUserName = sendBackUserName;
            this.sendBackComment = sendBackComment;
        }
    }
}
