package jp.agentec.abook.abv.bl.logic;

import java.util.List;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.acms.client.json.DashboardStatusJSON;
import jp.agentec.abook.abv.bl.acms.client.parameters.AcmsParameters;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.NetworkDisconnectedException;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.dao.ReportStatusDao;
import jp.agentec.abook.abv.bl.dto.DashboardStatusDto;


public class ReportStatusLogic extends AbstractLogic {
    private static final String TAG = "ReportStatusLogic";

    private List<DashboardStatusDto> getDashboardStatus() {
        if (!networkAdapter.isNetworkConnected()) {
            return null;
        }
        try {
            AcmsClient client = AcmsClient.getInstance(networkAdapter);
            String sid = cache.getMemberInfo().sid;
            AcmsParameters params = new AcmsParameters(sid);
            DashboardStatusJSON statuses = client.getDashboardStatus(params);
            return statuses.getReportStatuses();
        } catch (NetworkDisconnectedException e) {
            return null;
        } catch (AcmsException e) {
            Logger.e(TAG, e.getLocalizedMessage());
            return null;
        }
    }

    public void loadReportStatus() {
        List<DashboardStatusDto> received = getDashboardStatus();

        if (received != null && !received.isEmpty()) {
            // DBの更新
            ReportStatusDao dao = new ReportStatusDao();
            dao.beginTransaction();
            try {
                dao.deleteAll();
                for (DashboardStatusDto dto : received) {
                    dao.insert(dto);
                }
                dao.commit();
            } catch (Throwable e) {
                dao.rollback();
            }
        }
    }

    /**
     * API checkapi/taskData/で得られた、
     * 　 reportStatus
     * 　 message
     * をJavaScriptのコールバックを呼び出すときに使用するため保持しておくところ。
     * スレッドセーフにはなっていないし、スコープはpublicだしという行儀の悪い実装方法であるが、
     * APIの呼び出しとコールバックの呼び出しが、コードとして遠くに離れているので、
     * 適切な方法がないため、やむなくこのような実装になっている。
     */
    public static class TaskReportExtParam {

        public String reportStatus;     // 0:成功、2:承認中、999:その他エラー
        public String message;          // reportStatus = 0 以外の時のエラーメッセージ   reportStatus = 0 の時は無し

        private static TaskReportExtParam instance = null;

        public static void stock(String reportStatus, String message) {
            if (instance == null) {
                instance = new TaskReportExtParam();
            }
            instance.reportStatus = reportStatus;
            instance.message = message;
        }

        public static TaskReportExtParam pick() {
            if (instance == null || instance.reportStatus == null) {
                return null;
            } else {
                return instance;
            }
        }

        public static void clear() {
            if (instance != null) {
                instance.message = null;
                instance.reportStatus = null;
            }
        }
    }
}
