package jp.agentec.abook.abv.ui.common.activity;

import android.content.DialogInterface;
import android.os.Bundle;

import jp.agentec.abook.abv.bl.dto.OperationDto;
import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.OperationLogic;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType.PushMessageKey;
import jp.agentec.abook.abv.ui.common.constant.ErrorMessage;
import jp.agentec.abook.abv.ui.common.dialog.ABookAlertDialog;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import jp.agentec.abook.abv.ui.common.util.PatternStringUtil;
import jp.agentec.abook.abv.ui.home.activity.OperationListActivity;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;
import jp.agentec.adf.util.StringUtil;

public class ShowPushMessageDailogActivity extends ABVUIActivity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		String data = getIntent().getExtras().getString(PushMessageKey.data);
		if (StringUtil.isNullOrEmpty(data)) {
            final long operationId = StringUtil.isNullOrEmpty(getIntent().getExtras().getString(PushMessageKey.operationId)) ? 0 : Long.parseLong(getIntent().getExtras().getString(PushMessageKey.operationId));

            if (operationId > 0) {
                final ABookAlertDialog alertDialog = AlertDialogUtil.createAlertDialog(ShowPushMessageDailogActivity.this, getRString(R.string.app_name), getIntent().getExtras().getString(PushMessageKey.message));

                // リソースパターンの適用
                alertDialog.setPositiveButton(PatternStringUtil.patternToInt(getApplicationContext(),
                                                R.string.work_report,
                                                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)),
                        new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int whichButton) {
                        if (contentRefresher.isRefreshing()) {
                            // リソースパターンの適用
                            ErrorMessage.showErrorMessageToast(ShowPushMessageDailogActivity.this, PatternStringUtil.patternToInt(getApplicationContext(),
                                                                                                                R.string.msg_routineTask_report_disable_refreshing,
                                                                                                                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                        } else if(ActivityHandlingHelper.getInstance().isMeetingConnected()) {
                            // リソースパターンの適用
                            ErrorMessage.showErrorMessageToast(ShowPushMessageDailogActivity.this, PatternStringUtil.patternToInt(getApplicationContext(),
                                                                                                                R.string.msg_routineTask_report_disable_meeting_room,
                                                                                                                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                        } else {
                            OperationLogic mOperationLogic = AbstractLogic.getLogic(OperationLogic.class);
                            OperationDto operationDto = mOperationLogic.getOperation(operationId);

                            if (operationDto == null) {
                                // リソースパターンの適用
                                ErrorMessage.showErrorMessageToast(ShowPushMessageDailogActivity.this, PatternStringUtil.patternToInt(getApplicationContext(),
                                                                                                                    R.string.msg_routineTask_report_disable_no_operation,
                                                                                                                    getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                            } else {
                                OperationListActivity operationListActivity = ActivityHandlingHelper.getInstance().getPreviousOperationListActivity();
                                if (operationListActivity != null && operationListActivity.needAutoSync()) {
                                    operationListActivity.autoSyncOperationId(operationId);
                                    return;
                                }
                                if (operationDto.needSyncFlg) {
                                    // リソースパターンの適用
                                    ErrorMessage.showErrorMessageToast(ShowPushMessageDailogActivity.this, PatternStringUtil.patternToInt(getApplicationContext(),
                                            R.string.msg_routineTask_report_disable_not_updated,
                                            getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                                } else {
                                    if (operationListActivity != null) {
                                        operationListActivity.startTaskDirectionOrReportView(operationDto);
                                    } else {
                                        // リソースパターンの適用
                                        ErrorMessage.showErrorMessageToast(ShowPushMessageDailogActivity.this, PatternStringUtil.patternToInt(getApplicationContext(),
                                                R.string.msg_routineTask_report_disable_not_list,
                                                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                                    }
                                }
                            }
                        }
                        dialog.dismiss();
                    }
                });

                alertDialog.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int whichButton) {
                        dialog.dismiss();
                    }
                });

                alertDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialog) {
                        finish();
                    }
                });

                alertDialog.show();
            } else {
				final ABookAlertDialog alertDialog = AlertDialogUtil.createAlertDialog(ShowPushMessageDailogActivity.this, getRString(R.string.app_name), getIntent().getExtras().getString(PushMessageKey.message));
				alertDialog.setPositiveButton(R.string.ok, null);
				alertDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
					@Override
					public void onDismiss(DialogInterface dialog) {
						finish();
					}
				});
				alertDialog.show();
            }
		}
	}
}
