package jp.agentec.abook.abv.ui.common.helper;

import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.activity.ABVActivity;
import jp.agentec.abook.abv.ui.common.dialog.ABookAlertDialog;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import android.content.DialogInterface;

public class NavigationUpdateForReader extends NavigationContentDownloadForReader {
	
	private long mContentId;
	private String mRepositoryFqdn;
	private String mShareKey;
	
	
	public NavigationUpdateForReader(NavigationForReaderInterface contentReaderInterface, String repositoryFqdn, String shareKey, long contentId, ABVActivity activity) {
		super (contentReaderInterface, activity);
		
		mContentId = contentId;
		mRepositoryFqdn = repositoryFqdn;
		mShareKey = shareKey;
	}
	
	@Override
	public void moveToNextDisposal() {
		mContentReaderInterface.UpdateContent(mRepositoryFqdn, mShareKey);
	}
	
	public void openContentView() {
		mContentReaderInterface.openContent(mContentId);
	}

	@Override
	public void showMessageDialog(String title, String msg) {
		ABookAlertDialog alertDialog = AlertDialogUtil.createAlertDialog(mActivity, title, msg);
		alertDialog.setPositiveButton(R.string.update, new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
				dialog.dismiss();
				moveToNextDisposal();
			}
		});
		
		alertDialog.setNeutralButton(R.string.open, new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
				dialog.dismiss();
				openContentView();
			}
		});
		
		alertDialog.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
				dialog.dismiss();
				mContentReaderInterface.onFinishPushActivity();
			}
		});
		alertDialog.show();
	}
}
