package jp.agentec.abook.abv.ui.home.activity;

import android.app.Activity;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;

import com.honeywell.barcode.HSMDecodeComponent;
import com.honeywell.barcode.HSMDecodeResult;
import com.honeywell.barcode.HSMDecoder;
import com.honeywell.barcode.Symbology;
import com.honeywell.license.ActivationManager;
import com.honeywell.license.ActivationResult;
import com.honeywell.plugins.decode.DecodeResultListener;

import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.activity.ABVUIActivity;
import jp.agentec.abook.abv.ui.common.dialog.ABookAlertDialog;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import jp.agentec.abook.abv.ui.home.plugin.BarCodeReaderCustomPluginResultListener;

/* The purpose of this sample code is to show the multiple different ways you can use bar code scanning functionality in your application.
 * Bar code scanning can be achieved in the following 3 ways:
 * 1) You can let HSMDecoder handle everything for you by simply calling hsmDecoder.scanBarcode();
 * 2) You can embed an HSMDecodeComponent into your own activity and size it how you see fit
 * 3) You can create a custom SwiftPlugin to completely control the look and operation of a scan event.  
 *    This custom plug-in must be registered with HSMDecoder and can be used with either method 1 or 2 mentioned above.
 */
public class BarCodeReaderActivity extends ABVUIActivity implements DecodeResultListener, BarCodeReaderCustomPluginResultListener {
    public HSMDecoder hsmDecoder;

	private int scanCount = 0;
	public static final String BARCODE_READING_DATA = "barcode_data";
	private static final String TAG = "BarCodeReaderActivity";

	@Override
    public void onCreate(Bundle savedInstanceState) {
    	try {
	        super.onCreate(savedInstanceState);
	      
	        //initialize GUI
	        initGuiElements();

            //activate the API with your license key
            ActivationResult activationResult = ActivationManager.activate(this, "trial-image-areyn-12062017");
			Logger.d(TAG, "activationResult = " + activationResult);

	        //get the singleton instance of the decoder
        	hsmDecoder = HSMDecoder.getInstance(this);
			Logger.d(TAG, "isDecodingEnabled !!!! [ " + hsmDecoder.isDecodingEnabled());

			//set all decoder related settings
			setSymbology();

			hsmDecoder.enableFlashOnDecode(false);
            hsmDecoder.enableSound(true);
            hsmDecoder.enableAimer(true);
            hsmDecoder.setAimerColor(Color.RED);
            hsmDecoder.setOverlayTextColor(Color.WHITE);
            hsmDecoder.addResultListener(this);
            
    	} catch(Exception e) {
    		e.printStackTrace();
    	}
    }
	@Override
	public void onDestroy()
	{
		super.onDestroy();

		//dispose of the decoder instance, this stops the underlying camera service and releases all associated resources
		HSMDecoder.disposeInstance();

	}

    public static void onDisposeInstance() {
		HSMDecoder.disposeInstance();
	}

	@Override
	public boolean onKeyUp(int keyCode, KeyEvent event) {
		if (keyCode == KeyEvent.KEYCODE_BACK) {
			onDisposeInstance();
			finish();
		} else {
			return super.onKeyUp(keyCode, event);
		}
		return false;
	}

	@Override
	public void onHSMDecodeResult(HSMDecodeResult[] barcodeData) {
		//handle results from the default decoding functionality
		displayBarcodeData(barcodeData);
	}
	
	@Override
	public void onCustomPluginResult(HSMDecodeResult[] barcodeData) {
		//handle results from your custom plug-in
		displayBarcodeData(barcodeData);
	}
	
	private void displayBarcodeData(HSMDecodeResult[] barcodeData) {
		if( barcodeData.length > 0) {
			HSMDecodeResult firstResult = barcodeData[0];
			Logger.d("firstResult.getBarcodeData() = " + firstResult.getBarcodeData());
			if (scanCount == 0) {
				scanCount = 1;
				hsmDecoder.enableSound(false);

				final String readingBarcodeData = firstResult.getBarcodeData();
				ABookAlertDialog saveDialog = AlertDialogUtil.createAlertDialog(this, getString(R.string.barcode));
				saveDialog.setMessage(readingBarcodeData);
				saveDialog.setButton(DialogInterface.BUTTON_POSITIVE, getResources().getString(R.string.ok), new DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialog, int which) {
						onDisposeInstance();
						// Okボタンタップし、保存作業の処理
						Intent intent = new Intent();
						intent.putExtra(BARCODE_READING_DATA, readingBarcodeData);
						setResult(Activity.RESULT_OK, intent);
						scanCount = 0;
						hsmDecoder.enableSound(true);

						finish();
					}
				});
				saveDialog.setButton(DialogInterface.BUTTON_NEGATIVE, getResources().getString(R.string.cancel), new DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialog, int which) {
						// cancelボタンタップし、処理
						scanCount = 0;
						hsmDecoder.enableSound(true);
					}
				});
				saveDialog.show();
			}
		}
	}

	// Setting Activity screen
	private void initGuiElements() {
		//stop the device from going to sleep and hide the title bar
		this.requestWindowFeature(Window.FEATURE_NO_TITLE);
		this.getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
		this.getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
		setContentView(R.layout.barcode_reader);
	}

	//set all decoder related settings
	private void setSymbology() {
		hsmDecoder.enableSymbology(Symbology.UPCA);
		hsmDecoder.enableSymbology(Symbology.CODE128);
		hsmDecoder.enableSymbology(Symbology.CODE39);
		hsmDecoder.enableSymbology(Symbology.QR);
		hsmDecoder.enableSymbology(Symbology.EAN8);

		hsmDecoder.enableSymbology(Symbology.MENU_TYPE_INT);
		hsmDecoder.enableSymbology(Symbology.MENU_TYPE_CHAR);
		hsmDecoder.enableSymbology(Symbology.MENU_TYPE_ARRAY);
		hsmDecoder.enableSymbology(Symbology.MENU_TYPE_MASK);
		hsmDecoder.enableSymbology(Symbology.UPCA_2CHAR_ADDENDA);
		hsmDecoder.enableSymbology(Symbology.UPCA_5CHAR_ADDENDA);
		hsmDecoder.enableSymbology(Symbology.UPCE0);
		hsmDecoder.enableSymbology(Symbology.UPCE1);
		hsmDecoder.enableSymbology(Symbology.UPCE_EXPAND);
		hsmDecoder.enableSymbology(Symbology.UPCE_2CHAR_ADDENDA);
		hsmDecoder.enableSymbology(Symbology.UPCE_5CHAR_ADDENDA);
		hsmDecoder.enableSymbology(Symbology.EAN8_2CHAR_ADDENDA);
		hsmDecoder.enableSymbology(Symbology.EAN8_5CHAR_ADDENDA);
		hsmDecoder.enableSymbology(Symbology.EAN13);
		hsmDecoder.enableSymbology(Symbology.EAN13_2CHAR_ADDENDA);
		hsmDecoder.enableSymbology(Symbology.EAN13_5CHAR_ADDENDA);
		hsmDecoder.enableSymbology(Symbology.EAN13_ISBN);
		hsmDecoder.enableSymbology(Symbology.GS1_128);
		hsmDecoder.enableSymbology(Symbology.C128_ISBT);
		hsmDecoder.enableSymbology(Symbology.COUPON_CODE);
		hsmDecoder.enableSymbology(Symbology.TRIOPTIC);
		hsmDecoder.enableSymbology(Symbology.I25);
		hsmDecoder.enableSymbology(Symbology.S25);
		hsmDecoder.enableSymbology(Symbology.IATA25);
		hsmDecoder.enableSymbology(Symbology.M25);
		hsmDecoder.enableSymbology(Symbology.CODE93);
		hsmDecoder.enableSymbology(Symbology.CODE11);
		hsmDecoder.enableSymbology(Symbology.CODABAR);
		hsmDecoder.enableSymbology(Symbology.TELEPEN);
		hsmDecoder.enableSymbology(Symbology.MSI);
		hsmDecoder.enableSymbology(Symbology.RSS_14);
		hsmDecoder.enableSymbology(Symbology.RSS_LIMITED);
		hsmDecoder.enableSymbology(Symbology.RSS_EXPANDED);
		hsmDecoder.enableSymbology(Symbology.CODABLOCK_F);
		hsmDecoder.enableSymbology(Symbology.PDF417);
		hsmDecoder.enableSymbology(Symbology.MICROPDF);
		hsmDecoder.enableSymbology(Symbology.COMPOSITE);
		hsmDecoder.enableSymbology(Symbology.COMPOSITE_WITH_UPC);
		hsmDecoder.enableSymbology(Symbology.AZTEC);
		hsmDecoder.enableSymbology(Symbology.MAXICODE);
		hsmDecoder.enableSymbology(Symbology.DATAMATRIX);
		hsmDecoder.enableSymbology(Symbology.DATAMATRIX_RECTANGLE);
		hsmDecoder.enableSymbology(Symbology.NEC25);
		hsmDecoder.enableSymbology(Symbology.GRID);
		hsmDecoder.enableSymbology(Symbology.DOT);
		hsmDecoder.enableSymbology(Symbology.HANXIN);
		hsmDecoder.enableSymbology(Symbology.HK25);
		hsmDecoder.enableSymbology(Symbology.KOREA_POST);
	}

	// 閉じるボタンの処理
	public void onClickCloseView(View v) {
		onDisposeInstance();

		finish();
	}
}