package jp.agentec.abook.abv.ui.home.activity;

import android.app.Activity;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;

import com.google.zxing.integration.android.IntentIntegrator;
import com.journeyapps.barcodescanner.CaptureManager;
import com.journeyapps.barcodescanner.CompoundBarcodeView;

import jp.agentec.abook.abv.launcher.android.R;
/**
 * QRコードリーダー画面
 */
public class CaptureQRCodeActivity extends Activity {
    public static final String OPERATION_QRCODE_SCHEME = "atform.qrcode://";
    public static final String QRCODE_OPERATION_ID = "id";

    private static final String TAG = IntentIntegrator.class.getSimpleName();
    private CaptureManager capture;
    private CompoundBarcodeView barcodeView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.capture_qrcode_layout);
        setFinishOnTouchOutside(false);
        barcodeView = (CompoundBarcodeView)findViewById(R.id.bar_code_id);
        capture = new CaptureManager(this, barcodeView);
        capture.initializeFromIntent(getIntent(), savedInstanceState);
        capture.decode();
    }

    public void onClick(View v) {
        finish();
    }

    @Override
    protected void onResume() {
        super.onResume();
        capture.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
        capture.onPause();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        capture.onDestroy();
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        capture.onSaveInstanceState(outState);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return barcodeView.onKeyDown(keyCode, event) || super.onKeyDown(keyCode, event);
    }

}