package jp.agentec.abook.abv.ui.home.activity;

import android.os.Bundle;
import android.view.View;
import android.view.WindowManager;
import android.widget.ListView;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.Constant;
import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.HelpDisplayInfoDto;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.activity.ABVUIActivity;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.util.PatternStringUtil;
import jp.agentec.abook.abv.ui.home.adapter.HelpAdapter;


/**
 * Created by kim jinsung on 2018/09/19.
 */

public class HelpActivity extends ABVUIActivity {
    private String mMainDescription;
    private static final String TAG = "HelpActivity";
    private List<HelpDisplayInfoDto> mHelpDisplayInfoList;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Logger.i(TAG, "onCreate");
        super.onCreate(savedInstanceState);

        setContentView(R.layout.ac_help_dialog);

        int helpViewType = getIntent().getIntExtra(ABookKeys.HELP_VIEW_TYPE, 0);
        mHelpDisplayInfoList = new ArrayList<>();
        setDisplayData(helpViewType);

        TextView mainDescriptionTextView = findViewById(R.id.tv_help_detail);
        View lineView = findViewById(R.id.v_line);

        if (mMainDescription == null) {
            mainDescriptionTextView.setVisibility(View.GONE);
            lineView.setVisibility(View.GONE);
        } else {
            mainDescriptionTextView.setVisibility(View.VISIBLE);
            lineView.setVisibility(View.VISIBLE);
            mainDescriptionTextView.setText(mMainDescription);
        }

        ListView mHelpListView = findViewById(R.id.lv_help);
        mHelpListView.setAdapter(new HelpAdapter(this, mHelpDisplayInfoList));
        mHelpListView.invalidate();
        mHelpListView.setClickable(false);
    }

    private void setDisplayData(int helpViewTye) {
        mMainDescription = null;
        switch (helpViewTye) {
            case Constant.HelpViewType.OperationListReporter:
                // リソースパターンの適用
                mMainDescription = PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_operation_list_main,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_operation_list_list_view,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_list_view));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_operation_list_panel_view,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_panel_view));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_operation_list_filter,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_filter));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_operation_list_filter_on,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_filter_selected));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_communication_menu,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_commuication_menu));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_operation_list_search,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_direction_list_search));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_operation_list_setting,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_direction_list_config));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_common_content_menu,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_common_content_menu));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_operation_list_pano,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_edit_360));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_operation_list_sync,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_direction_list_sync));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_operation_list_type_report,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_type_report));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_operation_list_type_report_reply,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_type_report_reply));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_operation_list_type_routine,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_type_routine));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_operation_list_base_360,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_360));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_operation_list_base_pdf,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_pdf));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_operation_list_base_list,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_list));
                break;
            case Constant.HelpViewType.CommonContent:
                // リソースパターンの適用
                mMainDescription = PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_common_content,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_operation_home,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_detail_home));

                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_common_all_download,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_common_all_save));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_common_download,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_common_save));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_common_open,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_common_open));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_common_update,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_common_update));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_common_delete,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_common_delete));
                break;
            case Constant.HelpViewType.PanoContentEdit:
                // リソースパターンの適用
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_operation_home,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_detail_home));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_pano_edit_add,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_edit_360type_local_add));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_pano_edit_server_save,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_edit_360type_save));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_pano_edit_server_add,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_edit_360type_server_add));
                break;
            case Constant.HelpViewType.PanoOperationReporter:
                mMainDescription = PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_pano_report_main,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));

                // リソースパターンの適用
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_operation_home,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_detail_home));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_task_director_list,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_pano_direct_list));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_360_move,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_pdf_move));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_360_touch,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_pdf_touch));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_task_code_hide,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_task_code_hide));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_task_pano_zoom,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_pano_direct_control));
                break;
            case Constant.HelpViewType.DrawingOperationReporter:
                mMainDescription = PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_drawing_report_main,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));

                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_operation_home,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_detail_home));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_task_director_list,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_pano_direct_list));

                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_pdf_move,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_pdf_move));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_pdf_touch,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_pdf_touch));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_pdf_code,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_pdf_code));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_pdf_pin,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_pdf_pin));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_task_code_hide,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_pdf_code_hide));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_pdf_pin_hide,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_pdf_pin_hide));

                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_drawing_zoom,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_pano_direct_control));
                break;

            case Constant.HelpViewType.ListOperationReporter:
                // リソースパターンの適用
                mMainDescription = PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_list_main,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_operation_home,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_detail_home));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_director_report_search,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_direct_list_search));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_report_task_unfinished_status,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_report_status_red));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_report_task_working_status,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_report_status_blue));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_report_task_completed_status,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_report_status_green));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_report_locked,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_unlock));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_report_send_back,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_sendback));
                break;
            case Constant.HelpViewType.RoutineTaskOperation:
                // リソースパターンの適用
                mMainDescription = PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_routineTask_list_main,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_operation_home,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_detail_home));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_routineTask_list_refresh,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_help_direct_list_refresh));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_routine_task_unfinished_status,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_routine_status_red));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_routine_task_working_status,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_routine_status_blue));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_routine_task_completed_status,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_routine_status_green));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_report_locked,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_unlock));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_report_send_back,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_sendback));
                break;
            case Constant.HelpViewType.OperationDashboard:
                mMainDescription = PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_dashboard,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_report_locked,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_unlock));
                mHelpDisplayInfoList.add(settingHelpDisplayInfo(PatternStringUtil.patternToString(getApplicationContext(),
                        R.string.msg_help_report_send_back,
                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), R.drawable.ic_sendback));
                break;
        }
        if (!(helpViewTye == Constant.HelpViewType.OperationListDirector || helpViewTye == Constant.HelpViewType.OperationListReporter || helpViewTye == Constant.HelpViewType.OperationDetail)) {
            getWindow().addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
        }
    }

    private HelpDisplayInfoDto settingHelpDisplayInfo(String helpDescription, int resourceId) {
        HelpDisplayInfoDto dto = new HelpDisplayInfoDto();
        dto.helpDescription = helpDescription;
        dto.resourceId = resourceId;
        return dto;
    }

    public void onClickCloseView(View v) {
        finish();
    }
}
