package jp.agentec.abook.abv.ui.home.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import java.util.List;

import jp.agentec.abook.abv.bl.acms.type.OperationType;
import jp.agentec.abook.abv.bl.common.Constant.ReportType;
import jp.agentec.abook.abv.bl.dto.OperationDto;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.util.PatternStringUtil;
import jp.agentec.abook.abv.ui.home.activity.OperationListActivity;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;
import jp.agentec.adf.util.StringUtil;

import static jp.agentec.abook.abv.cl.util.PreferenceUtil.getUserPref;

/**
 * Created by leej on 2019/03/06.
 */

public class OperationPanelAdapter extends AbstractOperationAdapter {
    final private String TAG = "OperationPanelAdapter";
    private Context mContext;
    private LayoutInflater mInflater;
    private int categoryId;
    private boolean mNormalSizeFlg;

    private OperationPanelAdapter.OperationListPanelAdapterListener mListener;

    public interface OperationListPanelAdapterListener {
        void onPanoEdit(OperationDto operationDto);

        void onSyncOperation(OperationDto operationDto);

        void onOpenDirectionsOrReportView(OperationDto operationDto);

        void onOpenRelatedContentList(OperationDto operationDto);

        void onShowEntryPanoContentDialog(OperationDto operationDto);
    }

    public OperationPanelAdapter(Context context, List<OperationDto> listItem) {
        this.mContext = context;
        this.listItem = listItem;
        mNormalSizeFlg = ((OperationListActivity)context).isNormalSize();
        mInflater = (LayoutInflater) mContext.getSystemService(mContext.LAYOUT_INFLATER_SERVICE);
    }

    public void setAdapterListener(OperationPanelAdapter.OperationListPanelAdapterListener listener) {
        this.mListener = listener;
    }

    @Override
    public int getCount() {
        return listItem.size();
    }

    @Override
    public OperationDto getItem(int position) {
        return listItem.get(position);
    }

    @Override
    public long getItemId(int position) {
        return listItem.get(position).operationId;
    }

    private static class ViewHolder {
        TextView tvOperationName;
        TextView tvDate;

        ImageView ivReportType;
        ImageView ivOperationType;
        // パンネルのレイアウト
        LinearLayout panelLayout;
        // 同期関連
        ImageView ivSync;
        // ステータス別作業数
        TextView reportCountNotStarted;
        TextView reportCountWorking;
        TextView reportCountCompleted;
    }

    @Override
    public View getView(int position, View convertView, final ViewGroup parent) {
        final OperationPanelAdapter.ViewHolder holder;
        if (convertView == null) {
            convertView = mInflater.inflate(R.layout.item_operation_panel, parent, false);
            holder = new OperationPanelAdapter.ViewHolder();
            holder.panelLayout = convertView.findViewById(R.id.panel_layout);
            holder.tvOperationName = convertView.findViewById(R.id.operation_name);
            holder.tvDate = convertView.findViewById(R.id.operation_date);

            // 報告タイプ
            holder.ivReportType = convertView.findViewById(R.id.report_type);
            // 作業ベースタイプ
            holder.ivOperationType = convertView.findViewById(R.id.operation_type);

            // 同期関連
            holder.ivSync = convertView.findViewById(R.id.btn_sync);

            //  ステータス別作業数
            holder.reportCountNotStarted = convertView.findViewById(R.id.report_count_not_started);
            holder.reportCountWorking = convertView.findViewById(R.id.report_count_working);
            holder.reportCountCompleted = convertView.findViewById(R.id.report_count_completed);

            convertView.setTag(holder);
        } else {
            holder = (OperationPanelAdapter.ViewHolder) convertView.getTag();
        }

        final OperationDto operationDto = getItem(position);

        if (operationDto != null) {
            setImageReportType(holder, operationDto.reportType);
            setImageOperationType(holder, operationDto.operationType);


            boolean noRoutineTaskAll = (operationDto.reportType == ReportType.RoutineTask && operationDto.reportCount == 0);
            holder.tvOperationName.setText(operationDto.operationName);
            if (operationDto.reportType == ReportType.RoutineTask) {
                if (StringUtil.isNullOrEmpty(operationDto.reportPeriod)) {
                    // リソースパターンの適用
                    holder.tvDate.setText(PatternStringUtil.patternToString(mContext,
                            R.string.msg_no_report_data,
                            getUserPref(mContext, AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                } else {
                    // リソースパターンの適用
                    holder.tvDate.setText(operationDto.reportPeriod);
                }
            } else {
                // リソースパターンの適用
                holder.tvDate.setText(DateTimeUtil.toString(operationDto.operationStartDate, DateTimeFormat.yyyyMMdd_slash) + " ~ " + DateTimeUtil.toString(operationDto.operationEndDate, DateTimeFormat.yyyyMMdd_slash));
            }

            // 同期ボタン表示・非表示
            if (operationDto.contentId != null && operationDto.contentId != 0) {
                if ((operationDto.needSyncFlg)) {
                    holder.ivSync.setVisibility(View.VISIBLE);
                } else {
                    // 定期点検プロジェクトではない場合、同期ボタンを非活性化する
                    holder.ivSync.setVisibility(View.INVISIBLE);
                }
            } else {
                // プロジェクトのコンテンツが存在しない場合は、同期ボタンを非活性化する
                holder.ivSync.setVisibility(View.INVISIBLE);
            }

            holder.reportCountNotStarted.setText(String.valueOf(operationDto.statusNotStartedCount));
            holder.reportCountWorking.setText(String.valueOf(operationDto.statusWorkingCount));
            holder.reportCountCompleted.setText(String.valueOf(operationDto.statusCompletedCount));

            // 全体のレイアウト（ボタン以外）のタップ処理
            holder.panelLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    listener.openReport(operationDto);
                }
            });

            // 同期ボタンのタップイベント
            holder.ivSync.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    listener.onSyncOperation(operationDto);
                }
            });
        }

        return convertView;
    }

    // ReportTypeで画像の設定
    private void setImageReportType(ViewHolder holder, int reportType) {
        switch (reportType) {
            case ReportType.Report :
                // 報告タイプ
                holder.ivReportType.setBackgroundResource(R.drawable.ic_panel_type1);
                break;
            case ReportType.RoutineTask :
                // 定期点検タイプ
                holder.ivReportType.setBackgroundResource(R.drawable.ic_panel_type2);
                break;
            case ReportType.ReportReply :
                // 報告（回答）タイプ
                holder.ivReportType.setBackgroundResource(R.drawable.ic_panel_type3);
                break;
        }
    }

    // OperationTypeで画像の設定
    private void setImageOperationType(OperationPanelAdapter.ViewHolder holder, int operationType) {
        switch (operationType) {
            case OperationType.LIST :
                // リスト
                holder.ivOperationType.setBackgroundResource(R.drawable.ic_panel_list);
                break;
            case OperationType.PANO :
                // 360
                holder.ivOperationType.setBackgroundResource(R.drawable.ic_panel_360);
                break;
            case OperationType.PDF :
                // PDF
                holder.ivOperationType.setBackgroundResource(R.drawable.ic_panel_draw);
                break;
        }
    }
}

