package jp.agentec.abook.abv.ui.home.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.List;

import jp.agentec.abook.abv.bl.dto.FixPushMessageDto;
import jp.agentec.abook.abv.bl.dto.SppDeviceDto;
import jp.agentec.abook.abv.launcher.android.R;

/**
 * SPP端末選択アダプタ用
 */

public class SelectSppDeviceAdapter extends ArrayAdapter<SppDeviceDto> {
    private LayoutInflater mInflater;
    private List<SppDeviceDto> mSppDeviceDtoList;

    public SelectSppDeviceAdapter(Context context, List<SppDeviceDto> sppDeviceDtoList) {
        super(context, 0, sppDeviceDtoList);
        mSppDeviceDtoList = sppDeviceDtoList;
        mInflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        final ViewHolder holder;
        if (convertView == null) {
            convertView = mInflater.inflate(R.layout.item_spp_device_select, parent, false);
            holder = new ViewHolder();
            holder.tvSppDeviceName = (TextView) convertView.findViewById(R.id.spp_device_name);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }

        final SppDeviceDto sppDeviceDto = getItem(position);

        if (sppDeviceDto != null) {
            holder.tvSppDeviceName.setText(sppDeviceDto.sppDeviceName);
        }
        return convertView;
    }
    private static class ViewHolder {
        TextView tvSppDeviceName;
    }
}


