package jp.agentec.abook.abv.ui.home.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageButton;
import android.widget.TextView;

import java.util.List;

import jp.agentec.abook.abv.bl.dto.PushMessageDto;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

import static jp.agentec.abook.abv.cl.util.PreferenceUtil.getUserPref;


/**
 * 作業一覧画面上部に表示する未読プッシュメッセージ表示用アダプター
 * Created by kim jinsung on 2024/05/28.
 */
public class UnreadPushMessageListAdapter extends BaseAdapter {
    private static final String TAG = "PushMessageListAdapter";
    private Context mContext;
    private LayoutInflater mInflater;
    private UnreadPushMessageListAdapter.UnreadPushMessageListAdapterListener listener;

    List<PushMessageDto> mListItem;

    public UnreadPushMessageListAdapter(Context context, List<PushMessageDto> objects) {
        mContext = context;
        mListItem = objects;
        mInflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    }

    @Override
    public int getCount() {
        return mListItem.size();
    }

    @Override
    public PushMessageDto getItem(int position) {
        return mListItem.get(position);
    }

    public void setItem(List<PushMessageDto> objects) {
        mListItem = objects;
        notifyDataSetChanged();
    }

    @Override
    public long getItemId(int position) {
        return mListItem.get(position).pushMessageId;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        final ViewHolder holder;
        if (convertView == null) {
            convertView = mInflater.inflate(R.layout.item_unread_push_message_list, parent, false);
            holder = new UnreadPushMessageListAdapter.ViewHolder();
            holder.sendDateTextView = (TextView) convertView.findViewById(R.id.tv_send_date);
            holder.messageTextView = (TextView) convertView.findViewById(R.id.tv_message);
            holder.moveOperationButton = (ImageButton) convertView.findViewById(R.id.ib_move_operation);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }
        final PushMessageDto pushMessageDto = getItem(position);
        settingDisplay(holder, pushMessageDto);
        return convertView;
    }

    private void settingDisplay(ViewHolder holder, final PushMessageDto pushMessageDto) {

        if (pushMessageDto != null) {
            holder.sendDateTextView.setText(DateTimeUtil.toString(pushMessageDto.pushSendDate, DateTimeFormat.yyyyMMddHHmm_slash));
            holder.messageTextView.setText(pushMessageDto.pushMessage);

            holder.moveOperationButton.setFocusable(false);

            if (pushMessageDto.operationName == null) {
                holder.moveOperationButton.setVisibility(View.INVISIBLE);
            } else {
                holder.moveOperationButton.setVisibility(View.VISIBLE);
                holder.moveOperationButton.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        listener.onMoveOperation(pushMessageDto.operationId);
                    }
                });
            }
        }
    }

    private class ViewHolder {
        TextView operationNameTextView;
        TextView sendDateTextView;
        TextView messageTextView;
        ImageButton moveOperationButton;
    }

    public void setAdapterListener(UnreadPushMessageListAdapterListener listener) {
        this.listener = listener;
    }

    public interface UnreadPushMessageListAdapterListener {
        void onMoveOperation(Long operationId);
    }
}