package jp.agentec.abook.abv.ui.home.helper;

import java.util.List;

import jp.agentec.abook.abv.bl.acms.type.OperationSortingType;
import jp.agentec.abook.abv.bl.dto.OperationDto;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.home.activity.OperationListActivity;

import static jp.agentec.abook.abv.cl.util.PreferenceUtil.getUserPref;

/**
 * Created by leej on 2019/06/24.
 */

public class HomeOperationListHelper extends OperationListHelper {

    private static final String TAG = "HomeOperationListHelper";

    public HomeOperationListHelper(OperationListActivity activity) {
        super(activity);
    }

    @Override
    protected List<OperationDto> findOperationList() throws Exception {
        // 報告 or 定期点検
        String reportTypeStr = getUserPref(mAppActivity, AppDefType.UserPrefKey.OPERATION_REPORT_TYPES, null);
        return operationLogic.getRefreshOperation(mAppActivity.mSearchWord, mAppActivity.mStartDateStr, mAppActivity.mEndDateStr, reportTypeStr);
    }
}